/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class DocumentPathFilter
implements PathFilter,
Configurable {
    public static final Log LOG = LogFactory.getLog(DocumentPathFilter.class);
    private String pattern;
    private Configuration conf;
    private FileSystem fs;

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public boolean accept(Path inPath) {
        String filename = inPath.getName();
        if (filename.matches(this.pattern)) {
            return true;
        }
        try {
            FileStatus[] status = this.fs.globStatus(inPath);
            if (status == null) {
                throw new IOException("Path in input_file_path doesn't exist: " + inPath);
            }
            for (FileStatus s : status) {
                if (!s.isDirectory()) continue;
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)("Skipped path: " + inPath + ", reason: " + e.getMessage()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.pattern = conf.get("mapreduce.marklogic.input.filepattern", ".*");
        String inPath = conf.get("mapreduce.input.fileinputformat.inputdir");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mapreduce.input.fileinputformat.inputdir: " + inPath));
        }
        Path path = new Path(inPath);
        try {
            this.fs = FileSystem.get((URI)path.toUri(), (Configuration)conf);
        }
        catch (IOException e) {
            LOG.error((Object)("Please check path: " + inPath), (Throwable)e);
        }
    }
}

