/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.RDFReader;
import com.marklogic.mapreduce.CompressionCodec;
import com.marklogic.mapreduce.LinkedMapWritable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.lang.PipedQuadsStream;
import org.apache.jena.riot.lang.PipedRDFIterator;
import org.apache.jena.riot.lang.PipedTriplesStream;

public class CompressedRDFReader<VALUEIN>
extends RDFReader<VALUEIN> {
    public static final Log LOG = LogFactory.getLog(CompressedRDFReader.class);
    public static final long COMPRESSIONFACTOR = 2L;
    private byte[] buf = new byte[65536];
    private InputStream zipIn;
    private ZipEntry currZipEntry;
    private CompressionCodec codec;
    private ExecutorService pool;

    @Override
    public void close() throws IOException {
        super.close();
        if (this.zipIn != null) {
            this.zipIn.close();
        }
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    @Override
    protected void initStream(InputSplit inSplit) throws IOException, InterruptedException {
        FSDataInputStream fileIn = this.openFile(inSplit, false);
        if (fileIn == null) {
            return;
        }
        URI zipURI = this.file.toUri();
        String codecString = this.conf.get("mapreduce.marklogic.input.compressioncodec", CompressionCodec.ZIP.toString());
        if (codecString.equalsIgnoreCase(CompressionCodec.ZIP.toString())) {
            int nb;
            ByteArrayOutputStream baos;
            this.zipIn = new ZipInputStream((InputStream)fileIn);
            this.codec = CompressionCodec.ZIP;
            block2: while (true) {
                try {
                    do {
                        this.currZipEntry = ((ZipInputStream)this.zipIn).getNextEntry();
                        if (this.currZipEntry == null) break block2;
                    } while (this.currZipEntry.getSize() == 0L);
                    this.subId = this.currZipEntry.getName();
                }
                catch (IllegalArgumentException e) {
                    LOG.warn((Object)("Skipped a zip entry in : " + this.file.toUri() + ", reason: " + e.getMessage()));
                    continue;
                }
                break;
            }
            if (this.currZipEntry == null) {
                LOG.warn((Object)("No valid entry in zip:" + this.file.toUri()));
                return;
            }
            long size = this.currZipEntry.getSize();
            if (size == -1L) {
                baos = new ByteArrayOutputStream();
                this.initParser(zipURI.toASCIIString() + "/" + this.subId, this.INMEMORYTHRESHOLD);
            } else {
                baos = new ByteArrayOutputStream((int)size);
                this.initParser(zipURI.toASCIIString() + "/" + this.subId, size);
            }
            while ((nb = this.zipIn.read(this.buf, 0, this.buf.length)) != -1) {
                baos.write(this.buf, 0, nb);
            }
            this.parse(this.subId, new ByteArrayInputStream(baos.toByteArray()));
        } else if (codecString.equalsIgnoreCase(CompressionCodec.GZIP.toString())) {
            long size = inSplit.getLength();
            this.zipIn = new GZIPInputStream((InputStream)fileIn);
            this.codec = CompressionCodec.GZIP;
            this.initParser(zipURI.toASCIIString(), size * 2L);
            this.parse(this.file.getName(), this.zipIn);
        } else {
            throw new UnsupportedOperationException("Unsupported codec: " + this.codec.name());
        }
    }

    protected void parse(String fsname, InputStream in) throws IOException {
        if (this.dataset == null) {
            if (this.lang == Lang.NQUADS || this.lang == Lang.TRIG) {
                this.rdfIter = new PipedRDFIterator();
                PipedQuadsStream stream = new PipedQuadsStream(this.rdfIter);
                this.rdfInputStream = stream;
            } else {
                this.rdfIter = new PipedRDFIterator();
                PipedTriplesStream stream = new PipedTriplesStream(this.rdfIter);
                this.rdfInputStream = stream;
            }
            this.jenaStreamingParser = new RDFReader.RunnableParser(this.origFn, fsname, in);
            this.pool.submit(this.jenaStreamingParser);
            this.pos = 0L;
            this.end = 1L;
        } else {
            this.loadModel(fsname, in);
        }
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        boolean stillReading = super.nextKeyValue();
        if (stillReading) {
            return true;
        }
        URI zipURI = this.file.toUri();
        if (this.codec.equals((Object)CompressionCodec.ZIP)) {
            ZipInputStream zis = (ZipInputStream)this.zipIn;
            while ((this.currZipEntry = zis.getNextEntry()) != null) {
                int nb;
                ByteArrayOutputStream baos;
                if (this.currZipEntry.getSize() == 0L) continue;
                long size = this.currZipEntry.getSize();
                if (size == -1L) {
                    baos = new ByteArrayOutputStream();
                    this.initParser(zipURI.toASCIIString() + "/" + this.currZipEntry.getName(), this.INMEMORYTHRESHOLD);
                } else {
                    baos = new ByteArrayOutputStream((int)size);
                    this.initParser(zipURI.toASCIIString() + "/" + this.currZipEntry.getName(), size);
                }
                while ((nb = zis.read(this.buf, 0, this.buf.length)) != -1) {
                    baos.write(this.buf, 0, nb);
                }
                this.parse(this.currZipEntry.getName(), new ByteArrayInputStream(baos.toByteArray()));
                boolean gotTriples = super.nextKeyValue();
                if (!gotTriples) continue;
                return true;
            }
            if (this.iterator != null && this.iterator.hasNext()) {
                this.close();
                this.initStream((InputSplit)this.iterator.next());
                return super.nextKeyValue();
            }
            return false;
        }
        return false;
    }

    public CompressedRDFReader(String version, LinkedMapWritable roleMap) {
        super(version, roleMap);
        this.compressed = true;
        this.pool = Executors.newFixedThreadPool(1);
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.hasNext ? 0.0f : 1.0f;
    }
}

