/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.ImportRecordReader;
import com.marklogic.contentpump.utilities.FileIterator;
import com.marklogic.mapreduce.CompressionCodec;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class CompressedDocumentReader<VALUEIN>
extends ImportRecordReader<VALUEIN> {
    public static final Log LOG = LogFactory.getLog(CompressedDocumentReader.class);
    protected InputStream zipIn;
    protected byte[] buf = new byte[65536];
    protected boolean hasNext = true;
    protected CompressionCodec codec;
    protected int batchSize;

    @Override
    public void close() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Closing " + this.file));
        }
        if (this.zipIn != null) {
            this.zipIn.close();
        }
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.hasNext ? 0.0f : 1.0f;
    }

    @Override
    public void initialize(InputSplit inSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.initConfig(context);
        this.batchSize = this.conf.getInt("mapreduce.marklogic.output.batchsize", 100);
        this.setFile(((FileSplit)inSplit).getPath());
        this.fs = this.file.getFileSystem(this.conf);
        FileStatus status = this.fs.getFileStatus(this.file);
        if (status.isDirectory()) {
            this.iterator = new FileIterator((FileSplit)inSplit, context);
            inSplit = (InputSplit)this.iterator.next();
        }
        this.initStream(inSplit);
    }

    protected void initStream(InputSplit inSplit) throws IOException {
        FSDataInputStream fileIn;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting " + this.file));
        }
        if ((fileIn = this.openFile(inSplit, false)) == null) {
            return;
        }
        String codecString = this.conf.get("mapreduce.marklogic.input.compressioncodec", CompressionCodec.ZIP.toString()).toUpperCase();
        try {
            this.codec = CompressionCodec.valueOf((String)codecString);
        }
        catch (IllegalArgumentException e) {
            String error = "Unsupported codec: " + this.codec.name();
            LOG.error((Object)error, (Throwable)new UnsupportedOperationException(error));
            return;
        }
        switch (this.codec) {
            case ZIP: {
                this.zipIn = new ZipInputStream((InputStream)fileIn);
                break;
            }
            case GZIP: {
                this.zipIn = new GZIPInputStream((InputStream)fileIn);
                String uri = this.makeURIFromPath(this.file);
                if (uri.toLowerCase().endsWith(".gz") || uri.toLowerCase().endsWith(".gzip")) {
                    uri = uri.substring(0, uri.lastIndexOf(46));
                }
                this.setKey(uri, 0, 0, true);
                break;
            }
            default: {
                String error = "Unsupported codec: " + this.codec.name();
                LOG.error((Object)error, (Throwable)new UnsupportedOperationException(error));
            }
        }
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        block9: {
            if (this.zipIn == null) {
                this.hasNext = false;
                return false;
            }
            if (this.codec == CompressionCodec.ZIP) {
                ZipInputStream zis = (ZipInputStream)this.zipIn;
                while (true) {
                    try {
                        ZipEntry zipEntry;
                        while ((zipEntry = zis.getNextEntry()) != null) {
                            if (zipEntry.getSize() == 0L) continue;
                            this.subId = zipEntry.getName();
                            String uri = this.makeURIForZipEntry(this.file, this.subId);
                            if (this.setKey(uri, 0, 0, true)) {
                                return true;
                            }
                            this.setValue(zipEntry.getSize());
                            return true;
                        }
                        break block9;
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn((Object)("Skipped a zip entry in : " + this.file.toUri() + ", reason: " + e.getMessage()));
                        continue;
                    }
                    break;
                }
            }
            if (this.codec == CompressionCodec.GZIP) {
                this.setValue(0L);
                this.zipIn.close();
                this.zipIn = null;
                this.hasNext = false;
                return true;
            }
            return false;
        }
        if (this.iterator != null && this.iterator.hasNext()) {
            this.close();
            this.initStream((InputSplit)this.iterator.next());
            return this.nextKeyValue();
        }
        this.hasNext = false;
        return false;
    }

    protected void setValue(long length) throws IOException {
        int size;
        ByteArrayOutputStream baos = length > 0L ? new ByteArrayOutputStream((int)length) : new ByteArrayOutputStream();
        while ((size = this.zipIn.read(this.buf, 0, this.buf.length)) != -1) {
            baos.write(this.buf, 0, size);
        }
        if (this.value instanceof Text) {
            ((Text)this.value).set(baos.toString(this.encoding));
        } else {
            if (this.batchSize > 1) {
                this.value = new BytesWritable();
            }
            ((BytesWritable)this.value).set(baos.toByteArray(), 0, baos.size());
        }
        baos.close();
    }
}

