/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.DelimitedTextReader;
import com.marklogic.contentpump.utilities.CSVParserFormatter;
import com.marklogic.contentpump.utilities.FileIterator;
import com.marklogic.contentpump.utilities.IdGenerator;
import com.marklogic.mapreduce.CompressionCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class CompressedDelimitedTextReader
extends DelimitedTextReader<Text> {
    public static final Log LOG = LogFactory.getLog(CompressedDelimitedTextReader.class);
    private byte[] buf = new byte[65536];
    private InputStream zipIn;
    private ZipEntry currZipEntry;
    private CompressionCodec codec;

    public CompressedDelimitedTextReader() {
        this.compressed = true;
    }

    @Override
    public void initialize(InputSplit inSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.initConfig(context);
        this.initDocType();
        this.initDelimConf();
        this.setFile(((FileSplit)inSplit).getPath());
        this.fs = this.file.getFileSystem(context.getConfiguration());
        FileStatus status = this.fs.getFileStatus(this.file);
        if (status.isDirectory()) {
            this.iterator = new FileIterator((FileSplit)inSplit, context);
            inSplit = (InputSplit)this.iterator.next();
        }
        this.initStream(inSplit);
    }

    protected void initStream(InputSplit inSplit) throws IOException {
        FSDataInputStream fileIn = this.openFile(inSplit, false);
        if (fileIn == null) {
            return;
        }
        String codecString = this.conf.get("mapreduce.marklogic.input.compressioncodec", CompressionCodec.ZIP.toString());
        if (codecString.equalsIgnoreCase(CompressionCodec.ZIP.toString())) {
            this.zipIn = new ZipInputStream((InputStream)fileIn);
            this.codec = CompressionCodec.ZIP;
        } else if (codecString.equalsIgnoreCase(CompressionCodec.GZIP.toString())) {
            this.zipIn = new GZIPInputStream((InputStream)fileIn);
            this.codec = CompressionCodec.GZIP;
        } else {
            throw new UnsupportedOperationException("Unsupported codec: " + codecString);
        }
        if (this.uriName == null) {
            this.generateId = this.conf.getBoolean("mapreduce.marklogic.input.generateuri", false);
            if (this.generateId) {
                this.idGen = new IdGenerator(this.file.toUri().getPath() + "-" + ((FileSplit)inSplit).getStart());
            } else {
                this.uriId = 0;
            }
        }
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.zipIn == null) {
            this.hasNext = false;
            return false;
        }
        if (this.instream == null) {
            if (this.codec.equals((Object)CompressionCodec.ZIP)) {
                return this.nextKeyValueInZip();
            }
            if (this.codec.equals((Object)CompressionCodec.GZIP)) {
                this.instream = new InputStreamReader(this.zipIn, this.encoding);
                this.parser = new CSVParser((Reader)this.instream, CSVParserFormatter.getFormat(this.delimiter, Character.valueOf('\"'), true, true));
                this.parserIterator = this.parser.iterator();
                return super.nextKeyValue();
            }
            throw new UnsupportedOperationException("Unsupported codec: " + this.codec.name());
        }
        if (this.codec.equals((Object)CompressionCodec.ZIP)) {
            if (super.nextKeyValue()) {
                return true;
            }
            return this.nextKeyValueInZip();
        }
        if (this.codec.equals((Object)CompressionCodec.GZIP)) {
            if (super.nextKeyValue()) {
                return true;
            }
            if (this.iterator != null && this.iterator.hasNext()) {
                this.close();
                this.initStream((InputSplit)this.iterator.next());
                this.instream = this.encoding == null ? new InputStreamReader(this.zipIn) : new InputStreamReader(this.zipIn, this.encoding);
                this.parser = new CSVParser((Reader)this.instream, CSVParserFormatter.getFormat(this.delimiter, Character.valueOf('\"'), true, true));
                this.parserIterator = this.parser.iterator();
                return super.nextKeyValue();
            }
            return false;
        }
        throw new UnsupportedOperationException("Unsupported codec: " + this.codec.name());
    }

    private boolean nextKeyValueInZip() throws IOException, InterruptedException {
        block3: {
            ZipInputStream zis = (ZipInputStream)this.zipIn;
            while (true) {
                this.currZipEntry = zis.getNextEntry();
                if (this.currZipEntry == null) break block3;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ZipEntry: " + this.currZipEntry.getName()));
                }
                if (this.currZipEntry.getSize() == 0L) continue;
                this.subId = this.currZipEntry.getName();
                this.instream = this.encoding == null ? new InputStreamReader(zis) : new InputStreamReader((InputStream)zis, this.encoding);
                this.parser = new CSVParser((Reader)this.instream, CSVParserFormatter.getFormat(this.delimiter, Character.valueOf('\"'), true, true));
                this.parserIterator = this.parser.iterator();
                this.fields = null;
                if (super.nextKeyValue()) break;
            }
            return true;
        }
        if (this.iterator != null && this.iterator.hasNext()) {
            this.close();
            this.initStream((InputSplit)this.iterator.next());
            return this.nextKeyValueInZip();
        }
        this.hasNext = false;
        return false;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.zipIn != null) {
            this.zipIn.close();
        }
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.hasNext ? 0.0f : 1.0f;
    }
}

