/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.ConfigConstants;
import com.marklogic.contentpump.DatabaseDocumentWithMeta;
import com.marklogic.contentpump.DocumentMetadata;
import com.marklogic.contentpump.ImportRecordReader;
import com.marklogic.contentpump.utilities.FileIterator;
import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.DatabaseDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class ArchiveRecordReader
extends ImportRecordReader<DatabaseDocumentWithMeta>
implements ConfigConstants {
    public static final Log LOG = LogFactory.getLog(ArchiveRecordReader.class);
    private ZipInputStream zipIn;
    private boolean hasNext = true;
    private static String EXTENSION = ".zip";
    private byte[] buf = new byte[65536];
    private boolean allowEmptyMeta = false;
    private int count = 0;
    private ContentType type;

    @Override
    public void close() throws IOException {
        if (this.zipIn != null) {
            this.zipIn.close();
        }
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.hasNext ? 0.0f : 1.0f;
    }

    @Override
    public void initialize(InputSplit inSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.initConfig(context);
        this.allowEmptyMeta = this.conf.getBoolean("mapreduce.marklogic.input.archive.metadataoptional", false);
        this.setFile(((FileSplit)inSplit).getPath());
        this.fs = this.file.getFileSystem(context.getConfiguration());
        FileStatus status = this.fs.getFileStatus(this.file);
        if (status.isDirectory()) {
            this.iterator = new FileIterator((FileSplit)inSplit, context);
            inSplit = (InputSplit)this.iterator.next();
        }
        this.initStream(inSplit);
    }

    protected void initStream(InputSplit inSplit) throws IOException {
        FSDataInputStream fileIn = this.openFile(inSplit, false);
        if (fileIn == null) {
            return;
        }
        int index = this.file.toUri().getPath().lastIndexOf(EXTENSION);
        String subStr = this.file.toUri().getPath().substring(0, index);
        index = subStr.lastIndexOf(45);
        String typeStr = subStr.substring(index + 1, subStr.length());
        this.type = ContentType.valueOf((String)typeStr);
        this.value = new DatabaseDocumentWithMeta();
        this.zipIn = new ZipInputStream((InputStream)fileIn);
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        ZipEntry zipEntry;
        if (this.zipIn == null) {
            this.hasNext = false;
            return false;
        }
        ZipInputStream zis = this.zipIn;
        if (this.value == null) {
            this.value = new DatabaseDocumentWithMeta();
        }
        while ((zipEntry = zis.getNextEntry()) != null) {
            this.subId = zipEntry.getName();
            long length = zipEntry.getSize();
            if (this.subId.endsWith(DocumentMetadata.NAKED)) {
                ((DatabaseDocumentWithMeta)((Object)this.value)).setMeta(this.getMetadataFromStream(length));
                String uri = this.subId.substring(0, this.subId.length() - DocumentMetadata.NAKED.length());
                this.setKey(uri, 0, 0, false);
                ((DatabaseDocumentWithMeta)((Object)this.value)).setContent(null);
                ++this.count;
                return true;
            }
            if (this.count % 2 == 0 && this.subId.endsWith(DocumentMetadata.EXTENSION)) {
                ((DatabaseDocumentWithMeta)((Object)this.value)).setMeta(this.getMetadataFromStream(length));
                ++this.count;
                continue;
            }
            if (this.count % 2 == 0 && !this.allowEmptyMeta) {
                this.setSkipKey(0, 0, "Missing metadata");
                return true;
            }
            this.setKey(this.subId, 0, 0, false);
            this.readDocFromStream(length, (DatabaseDocument)this.value);
            ++this.count;
            return true;
        }
        if (this.iterator != null && this.iterator.hasNext()) {
            this.close();
            this.initStream((InputSplit)this.iterator.next());
            return this.nextKeyValue();
        }
        this.hasNext = false;
        return false;
    }

    private void readDocFromStream(long entryLength, DatabaseDocument doc) throws IOException {
        int size;
        ByteArrayOutputStream baos = entryLength == -1L ? new ByteArrayOutputStream() : new ByteArrayOutputStream((int)entryLength);
        while ((size = this.zipIn.read(this.buf, 0, this.buf.length)) != -1) {
            baos.write(this.buf, 0, size);
        }
        doc.setContentType(this.type);
        doc.setContent(baos.toByteArray());
        baos.close();
    }

    private DocumentMetadata getMetadataFromStream(long entryLength) throws IOException {
        int size;
        ByteArrayOutputStream baos = entryLength == -1L ? new ByteArrayOutputStream() : new ByteArrayOutputStream((int)entryLength);
        while ((size = this.zipIn.read(this.buf, 0, this.buf.length)) != -1) {
            baos.write(this.buf, 0, size);
        }
        DocumentMetadata metadata = DocumentMetadata.fromXML(new StringReader(baos.toString()));
        baos.close();
        return metadata;
    }
}

