/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.ArchiveRecordReader;
import com.marklogic.contentpump.DatabaseDocumentWithMeta;
import com.marklogic.contentpump.FileAndDirectoryInputFormat;
import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.DocumentURIWithSourceInfo;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class ArchiveInputFormat
extends FileAndDirectoryInputFormat<DocumentURIWithSourceInfo, DatabaseDocumentWithMeta> {
    public static final Log LOG = LogFactory.getLog(ArchiveInputFormat.class);
    private static String EXTENSION = ".zip";

    public RecordReader<DocumentURIWithSourceInfo, DatabaseDocumentWithMeta> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new ArchiveRecordReader();
    }

    @Override
    protected boolean isSplitable(JobContext context, Path filename) {
        return false;
    }

    @Override
    public List<InputSplit> getSplits(JobContext job) throws IOException {
        List<InputSplit> splits = super.getSplits(job);
        Iterator<InputSplit> iter = splits.iterator();
        while (iter.hasNext()) {
            int index;
            InputSplit s = iter.next();
            Path file = ((FileSplit)s).getPath();
            String zipfile = file.toUri().getPath();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Zip file name: " + zipfile));
            }
            if ((index = file.toUri().getPath().lastIndexOf(EXTENSION)) == -1) {
                throw new IOException("Archive file should have suffix .zip");
            }
            String subStr = file.toUri().getPath().substring(0, index);
            index = subStr.lastIndexOf(45);
            if (index == -1) {
                throw new IOException("Not type information in Archive name");
            }
            String typeStr = subStr.substring(index + 1, subStr.length());
            try {
                ContentType.valueOf((String)typeStr);
            }
            catch (IllegalArgumentException ex) {
                LOG.error((Object)("Not a valid archive: " + zipfile));
                iter.remove();
            }
        }
        return splits;
    }
}

