/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl;

import com.marklogic.xcc.ResultItem;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.RequestPermissionException;
import com.marklogic.xcc.exceptions.RetryableXQueryException;
import com.marklogic.xcc.exceptions.ServerConnectionException;
import com.marklogic.xcc.exceptions.XQueryException;
import com.marklogic.xcc.impl.AdhocImpl;
import com.marklogic.xcc.impl.SessionImpl;
import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.XSHexBinary;
import com.marklogic.xcc.types.XSInteger;
import com.marklogic.xcc.types.impl.XsHexBinaryImpl;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceImpl
implements XAResource {
    private SessionImpl session;
    private XAResourceImpl joined = null;
    private boolean origCompatibleMode = false;
    private static final BigInteger bigZero = new BigInteger("0");
    private static final Map<Xid, BigInteger> coordinatorForestMap = Collections.synchronizedMap(new HashMap());
    private static final Map<Xid, XAResourceImpl> xaMap = Collections.synchronizedMap(new HashMap());

    public XAResourceImpl(SessionImpl session) {
        this.session = session;
    }

    private static AdhocImpl createAdhoc(SessionImpl session, String query, Xid xid, boolean doForestID) {
        AdhocImpl adhoc = new AdhocImpl(session, "xquery version '1.0-ml';\nimport module namespace xa='http://marklogic.com/xdmp/xa' at 'MarkLogic/xa.xqy';\ndeclare variable $f as xs:integer external;\ndeclare variable $g as xs:hexBinary external;\ndeclare variable $b as xs:hexBinary external;\ndeclare variable $xid as element(xa:xid) := xa:make-xid($f,$g,$b);\n" + (!doForestID ? "" : "declare variable $fid as xs:integer external;\ndeclare variable $forest as xs:unsignedLong? :=\n  if($fid eq 0) then () else xs:unsignedLong($fid);\n") + query, null);
        adhoc.setNewIntegerVariable("f", xid.getFormatId());
        adhoc.setNewVariable("g", ValueType.XS_HEX_BINARY, xid.getGlobalTransactionId());
        adhoc.setNewVariable("b", ValueType.XS_HEX_BINARY, xid.getBranchQualifier());
        if (doForestID) {
            BigInteger forestID = coordinatorForestMap.get(new XccXid(xid));
            if (forestID == null) {
                forestID = bigZero;
            }
            adhoc.setNewVariable("fid", ValueType.XS_INTEGER, forestID);
        }
        return adhoc;
    }

    private void handleException(RequestException e) throws XAException {
        int code = -3;
        if (e instanceof ServerConnectionException) {
            code = -7;
        } else if (e instanceof RequestPermissionException) {
            code = -5;
        } else if (e instanceof RetryableXQueryException) {
            code = 107;
        } else if (e instanceof XQueryException) {
            XQueryException xe = (XQueryException)e;
            if (xe.getCode().equals("XDMP-TIMELIMIT") || xe.getCode().equals("XDMP-CANCELED")) {
                code = 106;
            } else if (xe.getCode().equals("XDMP-ROLLBACK")) {
                code = 100;
            } else if (xe.getCode().equals("XDMP-DEADLOCK")) {
                code = 102;
            } else if (xe.getCode().equals("XDMP-NOTXN")) {
                code = 104;
            } else if (xe.getCode().equals("XDMP-READONLY")) {
                code = 3;
            } else if (xe.getCode().equals("XDMP-HEURCOM")) {
                code = 7;
            } else if (xe.getCode().equals("XDMP-HEURRB")) {
                code = 6;
            } else if (xe.getCode().equals("XDMP-DUPXID")) {
                code = -8;
            } else if (xe.getCode().equals("XDMP-XIDNOTFOUND")) {
                code = -4;
            } else if (xe.getCode().equals("XDMP-OWNTXN") || xe.getCode().equals("XDMP-NOTPREPARED") || xe.getCode().equals("XDMP-TXNCOMPLETED") || xe.getCode().equals("XDMP-NOTREMEMBERED") || xe.getCode().equals("XDMP-NOTCURRENT")) {
                code = -6;
            }
        }
        if (code < 0) {
            this.session.getLogger().log(Level.WARNING, "XAResource error condition", e);
        } else {
            this.session.getLogger().log(Level.INFO, "XAResource exception", e);
        }
        XAException toThrow = new XAException(code);
        toThrow.initCause(e);
        throw toThrow;
    }

    private static void handleFinally(ResultSequence rs, SessionImpl session) {
        if (rs != null) {
            rs.close();
        }
        if (session != null) {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start(Xid xid, int flags) throws XAException {
        block11: {
            this.origCompatibleMode = this.session.isInCompatibleMode();
            this.session.setCompatibleMode(true);
            this.session.getLogger().fine("XAResource.start, xid=" + xid.toString() + ", flags=" + flags);
            if (this.session.getTxnID() != null) {
                throw new XAException(-9);
            }
            boolean join = flags == 0x200000 || flags == 0x8000000;
            try {
                AdhocImpl adhoc = XAResourceImpl.createAdhoc(this.session, join ? "xa:join($xid)" : "xa:start($xid)", xid, false);
                this.session.submitRequestInternal(adhoc).close();
                SessionImpl sessionImpl = this.session;
                synchronized (sessionImpl) {
                    this.session.inXATxn = true;
                }
                if (join) {
                    XAResourceImpl other = xaMap.get(new XccXid(xid));
                    if (other != null && other != this) {
                        XAResourceImpl xAResourceImpl = other;
                        synchronized (xAResourceImpl) {
                            this.joined = other.joined;
                            other.joined = this;
                            break block11;
                        }
                    }
                    xaMap.put(new XccXid(xid), this);
                    break block11;
                }
                xaMap.put(new XccXid(xid), this);
            }
            catch (RequestException e) {
                this.handleException(e);
            }
        }
    }

    @Override
    public synchronized void end(Xid xid, int flags) throws XAException {
        block3: {
            this.session.getLogger().fine("XAResource.end, xid=" + xid.toString() + ", flags=" + flags);
            try {
                AdhocImpl adhoc = XAResourceImpl.createAdhoc(this.session, "xa:end($xid)", xid, false);
                this.session.submitRequestInternal(adhoc).close();
            }
            catch (RequestException e) {
                if (e instanceof XQueryException && ((XQueryException)e).getCode().equals("XDMP-NOTCURRENT")) break block3;
                this.handleException(e);
            }
        }
        if (this.joined != null) {
            this.joined.ended();
            this.joined = null;
        }
        xaMap.remove(new XccXid(xid));
        this.session.setCompatibleMode(this.origCompatibleMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void ended() {
        if (this.joined != null) {
            this.joined.ended();
            this.joined = null;
        }
        SessionImpl sessionImpl = this.session;
        synchronized (sessionImpl) {
            this.session.inXATxn = false;
            this.session.txnID = null;
            this.session.sessionID = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepare(Xid xid) throws XAException {
        SessionImpl backChannel = this.session.clone();
        ResultSequence rs = null;
        try {
            backChannel.getLogger().fine("XAResource.prepare, xid=" + xid.toString());
            AdhocImpl adhoc = XAResourceImpl.createAdhoc(backChannel, "xa:prepare($xid)", xid, false);
            rs = backChannel.submitRequestInternal(adhoc);
            BigInteger forestID = ((XSInteger)rs.next().getItem()).asBigInteger();
            if (forestID.compareTo(bigZero) == 0) {
                int n = 3;
                XAResourceImpl.handleFinally(rs, backChannel);
                return n;
            }
            coordinatorForestMap.put(new XccXid(xid), forestID);
            XAResourceImpl.handleFinally(rs, backChannel);
        }
        catch (RequestException e) {
            this.handleException(e);
        }
        finally {
            XAResourceImpl.handleFinally(rs, backChannel);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        SessionImpl backChannel = this.session.clone();
        try {
            backChannel.getLogger().fine("XAResource.commit, xid=" + xid.toString() + ", onePhase=" + onePhase);
            AdhocImpl adhoc = XAResourceImpl.createAdhoc(backChannel, "xa:commit($xid,$forest)", xid, true);
            backChannel.submitRequestInternal(adhoc).close();
            coordinatorForestMap.remove(new XccXid(xid));
        }
        catch (RequestException e) {
            this.handleException(e);
        }
        finally {
            XAResourceImpl.handleFinally(null, backChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        SessionImpl backChannel = this.session.clone();
        try {
            backChannel.getLogger().fine("XAResource.rollback, xid=" + xid.toString());
            AdhocImpl adhoc = XAResourceImpl.createAdhoc(backChannel, "xa:rollback($xid,$forest)", xid, true);
            backChannel.submitRequestInternal(adhoc).close();
            coordinatorForestMap.remove(new XccXid(xid));
        }
        catch (RequestException e) {
            this.handleException(e);
        }
        finally {
            XAResourceImpl.handleFinally(null, backChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forget(Xid xid) throws XAException {
        SessionImpl backChannel = this.session.clone();
        try {
            backChannel.getLogger().fine("XAResource.forget, xid=" + xid.toString());
            AdhocImpl adhoc = XAResourceImpl.createAdhoc(backChannel, "xa:forget($xid,$forest)", xid, true);
            backChannel.submitRequestInternal(adhoc).close();
            coordinatorForestMap.remove(new XccXid(xid));
        }
        catch (RequestException e) {
            this.handleException(e);
        }
        finally {
            XAResourceImpl.handleFinally(null, backChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Xid[] recover(int flag) throws XAException {
        ArrayList<XccXid> result = new ArrayList<XccXid>();
        SessionImpl backChannel = this.session.clone();
        ResultSequence rs = null;
        try {
            ResultItem item;
            backChannel.getLogger().fine("XAResource.recover, flag=" + flag);
            if (flag != 0x1000000) {
                Xid[] xidArray = new Xid[]{};
                return xidArray;
            }
            AdhocImpl adhoc = new AdhocImpl(backChannel, "xquery version '1.0-ml';\nimport module namespace xa='http://marklogic.com/xdmp/xa' at 'MarkLogic/xa.xqy';\nfor $xid in xa:recover() return (\n  $xid/@format-id cast as xs:integer,\n  $xid/xa:global-transaction-id cast as xs:hexBinary,\n  $xid/xa:branch-qualifier cast as xs:hexBinary)", null);
            rs = backChannel.submitRequestInternal(adhoc);
            while ((item = rs.next()) != null) {
                if (!(item.getItem() instanceof XSInteger)) {
                    backChannel.getLogger().severe("XAResourceImpl.recover() expecting XSInteger");
                    break;
                }
                int format = ((XSInteger)item.getItem()).asPrimitiveInt();
                item = rs.next();
                if (item == null || !(item.getItem() instanceof XSHexBinary)) {
                    backChannel.getLogger().severe("XAResourceImpl.recover() expecting XSHexBinary");
                    break;
                }
                byte[] gtid = ((XSHexBinary)item.getItem()).asBinaryData();
                item = rs.next();
                if (item == null || !(item.getItem() instanceof XSHexBinary)) {
                    backChannel.getLogger().severe("XAResourceImpl.recover() expecting XSHexBinary");
                    break;
                }
                byte[] bq = ((XSHexBinary)item.getItem()).asBinaryData();
                result.add(new XccXid(format, gtid, bq));
            }
            XAResourceImpl.handleFinally(rs, backChannel);
        }
        catch (RequestException e) {
            this.handleException(e);
        }
        finally {
            XAResourceImpl.handleFinally(rs, backChannel);
        }
        return result.toArray(new Xid[0]);
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        if (xares instanceof XAResourceImpl) {
            XAResourceImpl other = (XAResourceImpl)xares;
            if (!this.session.getContentSource().getConnectionProvider().equals(other.session.getContentSource().getConnectionProvider())) {
                return false;
            }
            if (!this.session.getUserCredentials().toHttpBasicAuth().equals(other.session.getUserCredentials().toHttpBasicAuth())) {
                return false;
            }
            return !(this.session.getContentBaseName() == null ? other.session.getContentBaseName() != null : other.session.getContentBaseName() == null || !this.session.getContentBaseName().equals(other.session.getContentBaseName()));
        }
        return false;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        try {
            return this.session.getTransactionTimeout();
        }
        catch (RequestException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        try {
            this.session.setTransactionTimeout(seconds);
        }
        catch (RequestException e) {
            this.handleException(e);
        }
        return true;
    }

    private static class XccXid
    implements Xid {
        private int format;
        private byte[] gtid;
        private byte[] bq;

        public XccXid(int f, byte[] g, byte[] b) {
            this.format = f;
            this.gtid = g;
            this.bq = b;
        }

        public XccXid(Xid o) {
            this.format = o.getFormatId();
            this.gtid = o.getGlobalTransactionId();
            this.bq = o.getBranchQualifier();
        }

        @Override
        public int getFormatId() {
            return this.format;
        }

        @Override
        public byte[] getGlobalTransactionId() {
            return this.gtid;
        }

        @Override
        public byte[] getBranchQualifier() {
            return this.bq;
        }

        public boolean equals(Object o) {
            return o instanceof Xid && this.format == ((Xid)o).getFormatId() && Arrays.equals(this.gtid, ((Xid)o).getGlobalTransactionId()) && Arrays.equals(this.bq, ((Xid)o).getBranchQualifier());
        }

        public int hashCode() {
            int hash = this.format;
            for (byte b : this.gtid) {
                hash += b;
            }
            for (byte b : this.bq) {
                hash += b;
            }
            return hash;
        }

        public String toString() {
            return "< format=" + this.format + ", gtid=" + XsHexBinaryImpl.convertBinaryToHex(this.gtid) + ", bq=" + XsHexBinaryImpl.convertBinaryToHex(this.bq) + " >";
        }
    }
}

