/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc;

import com.marklogic.xcc.ContentCapability;

public class ContentPermission {
    public static final ContentCapability READ = ContentCapability.READ;
    public static final ContentCapability INSERT = ContentCapability.INSERT;
    public static final ContentCapability UPDATE = ContentCapability.UPDATE;
    public static final ContentCapability EXECUTE = ContentCapability.EXECUTE;
    public static final ContentCapability NODE_UPDATE = ContentCapability.NODE_UPDATE;
    private ContentCapability capability;
    private String role;
    private String roleId;

    public ContentPermission(ContentCapability capability, String role) {
        this(capability, role, null);
    }

    public ContentPermission(ContentCapability capability, String role, String roleId) {
        if (role == null) {
            throw new IllegalArgumentException("Role may not be null");
        }
        String trimmedRole = role.trim();
        if (trimmedRole.length() == 0) {
            throw new IllegalArgumentException("Role may not be empty");
        }
        String trimmedId = roleId == null ? null : roleId.trim();
        this.capability = capability;
        this.role = trimmedRole;
        this.roleId = trimmedId;
    }

    public static ContentPermission newReadPermission(String role) {
        return new ContentPermission(READ, role);
    }

    public static ContentPermission newInsertPermission(String role) {
        return new ContentPermission(INSERT, role);
    }

    public static ContentPermission newUpdatePermission(String role) {
        return new ContentPermission(UPDATE, role);
    }

    public static ContentPermission newExecutePermission(String role) {
        return new ContentPermission(EXECUTE, role);
    }

    public static ContentPermission newNodeUpdatePermission(String role) {
        return new ContentPermission(NODE_UPDATE, role);
    }

    public ContentCapability getCapability() {
        return this.capability;
    }

    public String getRole() {
        return this.role;
    }

    public String getId() {
        return this.roleId;
    }

    public String toString() {
        return "[DocPermission: role=" + this.role + ", capability=" + this.capability + "]";
    }

    public boolean equals(Object obj) {
        ContentPermission p;
        if (this == obj) {
            return true;
        }
        return obj instanceof ContentPermission && this.role.equals((p = (ContentPermission)obj).getRole()) && this.capability == p.getCapability();
    }

    public int hashCode() {
        return (this.role + this.capability.toString()).hashCode();
    }
}

