/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.http;

import com.marklogic.http.HttpHeaders;
import com.marklogic.io.LengthLimitedInputStream;
import com.marklogic.io.SslByteChannel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpChannel {
    public static final String USEHTTP_PROPERTY_NAME = "xcc.httpcompliant";
    public static final String RCV_TIME_HEADER = "X-XCC-Received";
    static final int DEFAULT_BUFFER_SIZE = 65536;
    static final int MINIMUM_BUFFER_SIZE = 1024;
    static final int MAXIMUM_BUFFER_SIZE = 0x2000000;
    private final ByteChannel channel;
    private final HttpHeaders requestHeaders = new HttpHeaders();
    private final HttpHeaders responseHeaders = new HttpHeaders();
    private final InputStream inStream;
    private final ByteBuffer bodyBuffer;
    private final Logger logger;
    private boolean suppressHeaders = false;
    private boolean closeOutputIfNoContentLength = false;
    private boolean headersParsed = false;
    private boolean headersWritten = false;
    private static AtomicBoolean useHTTP = new AtomicBoolean("true".equalsIgnoreCase(System.getProperty("xcc.httpcompliant")));

    private boolean isChunked() {
        String te = this.getRequestHeader("Transfer-Encoding");
        return te == null ? false : te.equalsIgnoreCase("chunked");
    }

    private boolean isKeepAlive() {
        String ka = this.getRequestHeader("Connection");
        return ka == null ? false : ka.equalsIgnoreCase("keep-alive");
    }

    public static boolean isUseHTTP() {
        return useHTTP.get();
    }

    public static void setUseHTTP(boolean val) {
        useHTTP.set(val);
    }

    public HttpChannel(ByteChannel channel, String method, String path, int bufferSize, int timeoutMillis, Logger logger) {
        this.channel = channel;
        this.logger = logger == null ? Logger.getLogger(this.getClass().getName()) : logger;
        this.requestHeaders.setRequestValues(method, path, HttpChannel.isUseHTTP() ? "HTTP/1.1" : "XDBC/1.0");
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("XDBC request: " + this.requestHeaders.getRequestLine());
        }
        this.bodyBuffer = this.allocBuffer(bufferSize);
        this.inStream = new ChannelInputStream(channel, this.bodyBuffer, timeoutMillis);
    }

    public void reset(String method, String path) {
        this.suppressHeaders = false;
        this.closeOutputIfNoContentLength = false;
        this.headersParsed = false;
        this.headersWritten = false;
        this.requestHeaders.clear();
        this.responseHeaders.clear();
        this.bodyBuffer.clear();
        this.requestHeaders.setRequestValues(method, path, HttpChannel.isUseHTTP() ? "HTTP/1.1" : "XDBC/1.0");
    }

    public ByteChannel getChannel() {
        return this.channel;
    }

    public void setCloseOutputIfNoContentLength(boolean value) {
        this.closeOutputIfNoContentLength = value;
    }

    public int write(byte[] bytes, int offset, int length) throws IOException {
        int len;
        for (int srcRemaining = length; srcRemaining > 0; srcRemaining -= len) {
            if (this.bodyBuffer.remaining() == 0) {
                this.flushRequest(false);
            }
            len = Math.min(srcRemaining, this.bodyBuffer.remaining());
            this.bodyBuffer.put(bytes, offset + (length - srcRemaining), len);
        }
        return length;
    }

    public int write(byte[] bytes) throws IOException {
        return this.write(bytes, 0, bytes.length);
    }

    public void writeString(String value) throws IOException {
        this.write(value.getBytes("UTF-8"));
    }

    public void write(ByteBuffer buffer) throws IOException {
        if (buffer.limit() < this.bodyBuffer.remaining()) {
            this.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
            return;
        }
        this.flushRequest(false);
        this.writeBuffer(this.channel, buffer);
    }

    public InputStream getResponseStream() throws IOException {
        this.receiveMode();
        if (this.getResponseContentLength() != -1) {
            return new LengthLimitedInputStream(this.inStream, this.getResponseContentLength());
        }
        return this.inStream;
    }

    public void setRequestHeader(String header, String value) {
        this.requestHeaders.setHeader(header, value);
    }

    public String getRequestHeader(String header) {
        return this.requestHeaders.getHeader(header);
    }

    public void setRequestContentType(String value) {
        this.requestHeaders.setHeader("Content-Type", value);
    }

    public void setRequestContentLength(int length) {
        this.requestHeaders.setHeader("Content-Length", "" + length);
    }

    public String getResponseHeader(String headerName) throws IOException {
        this.receiveMode();
        return this.responseHeaders.getHeaderNormalized(headerName);
    }

    public List<String> getResponseHeaders(String headerName) throws IOException {
        this.receiveMode();
        return this.responseHeaders.getAllHeadersNormalized(headerName);
    }

    public int getResponseCode() throws IOException {
        this.receiveMode();
        return this.responseHeaders.getResponseCode();
    }

    public String getResponseMessage() throws IOException {
        this.receiveMode();
        return this.responseHeaders.getResponseMessage();
    }

    public int getResponseContentLength() throws IOException {
        this.receiveMode();
        return this.responseHeaders.getContentLength();
    }

    public String getResponseContentType() throws IOException {
        this.receiveMode();
        return this.responseHeaders.getContentType();
    }

    public String getResponseContentTypeField(String fieldName) throws IOException {
        this.receiveMode();
        return this.responseHeaders.getContentTypeField(fieldName);
    }

    public String getResponseContentBoundary() throws IOException {
        this.getResponseContentType();
        return this.responseHeaders.getHeaderSubValue("content-type", "boundary", ";");
    }

    public String getReponseCookieValue(String key) throws IOException {
        this.receiveMode();
        return this.responseHeaders.getHeaderSubValue("set-cookie", key, ";");
    }

    public long getResponseHeaderRecvTime() throws IOException {
        this.receiveMode();
        String val = this.responseHeaders.getHeaderNormalized(RCV_TIME_HEADER);
        if (val == null) {
            val = this.responseHeaders.getHeader(RCV_TIME_HEADER);
        }
        if (val == null) {
            return 0L;
        }
        return Long.parseLong(val);
    }

    public long getResponseKeepaliveExpireTime() throws IOException {
        this.receiveMode();
        int keepAliveSeconds = this.getResponseKeepaliveSeconds();
        if (keepAliveSeconds == 0) {
            return 0L;
        }
        return this.getResponseHeaderRecvTime() + (long)(keepAliveSeconds * 1000);
    }

    public int getResponseKeepaliveSeconds() throws IOException {
        this.receiveMode();
        String header = this.responseHeaders.getHeader("connection");
        if (header == null || !header.equalsIgnoreCase("keep-alive")) {
            return 0;
        }
        Integer val = this.responseHeaders.getHeaderSubValueInt("keep-alive", "timeout", ",");
        return val == null ? 0 : val;
    }

    public void suppressHeaders() {
        this.suppressHeaders = true;
    }

    private void receiveMode() throws IOException {
        this.flushRequest(true);
        this.checkCloseOutput();
        if (this.headersParsed) {
            return;
        }
        this.parseHeaders();
    }

    private void checkCloseOutput() throws IOException {
        if (!this.closeOutputIfNoContentLength) {
            return;
        }
        String connHeader = this.getRequestHeader("Connection");
        if (connHeader == null || !connHeader.equalsIgnoreCase("keep-alive")) {
            if (this.channel instanceof SocketChannel) {
                SocketChannel sockChannel = (SocketChannel)this.channel;
                sockChannel.socket().shutdownOutput();
            } else if (this.channel instanceof SslByteChannel) {
                ((SslByteChannel)this.channel).close(false);
            }
        }
    }

    private void parseHeaders() throws IOException {
        long now = System.currentTimeMillis();
        this.logger.finer("parsing response headers");
        this.responseHeaders.parseResponseHeaders(this.inStream);
        if (this.responseHeaders.getHeader(RCV_TIME_HEADER) == null) {
            this.responseHeaders.setHeader(RCV_TIME_HEADER, "" + now);
        }
        this.headersParsed = true;
    }

    public String getServerVersion() throws IOException {
        this.receiveMode();
        String header = this.getResponseHeader("server");
        if (header != null && header.startsWith("MarkLogic ")) {
            return header.substring(10);
        }
        return null;
    }

    private void flushRequest(boolean finished) throws IOException {
        if (!this.headersWritten) {
            if (finished) {
                if (!this.isChunked()) {
                    this.setRequestContentLength(this.bodyBuffer.position());
                }
                if (!this.isKeepAlive()) {
                    this.setRequestHeader("Connection", "keep-alive");
                }
            }
            this.writeHeaders();
        }
        this.writeBody();
    }

    private void writeBody() throws IOException {
        this.bodyBuffer.flip();
        this.writeBuffer(this.channel, this.bodyBuffer);
        this.bodyBuffer.clear();
    }

    private void writeHeaders() throws IOException {
        if (!this.suppressHeaders) {
            byte[] headerBytes = this.requestHeaders.toString().getBytes("UTF-8");
            ByteBuffer headersBuffer = ByteBuffer.wrap(headerBytes);
            this.writeBuffer(this.channel, headersBuffer);
        }
        this.headersWritten = true;
    }

    private void writeBuffer(ByteChannel channel, ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            channel.write(buffer);
        }
    }

    ByteBuffer allocBuffer(int size) {
        int bufSize = size <= 0 ? 65536 : size;
        bufSize = Math.max(bufSize, 1024);
        bufSize = Math.min(bufSize, 0x2000000);
        try {
            return ByteBuffer.allocateDirect(bufSize);
        }
        catch (OutOfMemoryError e) {
            return ByteBuffer.allocate(bufSize);
        }
    }

    private static class ChannelInputStream
    extends InputStream {
        private static final int DIRECT_READ_THRESHOLD = 8192;
        private final ReadableByteChannel channel;
        private final ByteBuffer buffer;
        private int timeoutMillis;
        private Selector selector = null;

        public ChannelInputStream(ReadableByteChannel channel, ByteBuffer buffer, int timeoutMillis) {
            this.channel = channel;
            this.buffer = buffer.duplicate();
            this.timeoutMillis = timeoutMillis;
            this.buffer.clear();
            this.buffer.flip();
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            if (off < 0 || off > bytes.length || len < 0 || off + len > bytes.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            int rc = this.attemptCopyOut(bytes, off, len);
            if (rc != 0) {
                return rc;
            }
            if (len >= 8192) {
                ByteBuffer buffer = ByteBuffer.wrap(bytes, off, len);
                buffer.position(off);
                buffer.limit(Math.min(off + len, buffer.capacity()));
                return this.channel.read(buffer);
            }
            rc = this.fillBuffer();
            if (rc < 0) {
                return -1;
            }
            return this.attemptCopyOut(bytes, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read() throws IOException {
            if (this.buffer.hasRemaining()) {
                return this.buffer.get() & 0xFF;
            }
            byte[] buf = new byte[1];
            int rc = this.read(buf, 0, 1);
            if (rc == -1) {
                return -1;
            }
            return buf[0] & 0xFF;
        }

        private int attemptCopyOut(byte[] bytes, int off, int len) {
            int toRead;
            int bufferedCount = this.buffer.remaining();
            int n = toRead = bufferedCount < len ? bufferedCount : len;
            if (toRead != 0) {
                this.buffer.get(bytes, off, toRead);
            }
            return toRead;
        }

        private int fillBuffer() throws IOException {
            this.buffer.clear();
            int rc = this.timedRead(this.buffer);
            this.buffer.flip();
            return rc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int timedRead(ByteBuffer buffer) throws IOException {
            if (this.channel instanceof SslByteChannel) {
                SslByteChannel ch = (SslByteChannel)this.channel;
                int tmp = ch.getTimeout();
                ch.setTimeout(this.timeoutMillis);
                try {
                    int n = ch.read(buffer);
                    return n;
                }
                finally {
                    ch.setTimeout(tmp);
                }
            }
            if (this.timeoutMillis <= 0 || !(this.channel instanceof SelectableChannel)) {
                return this.channel.read(buffer);
            }
            SelectableChannel schannel = (SelectableChannel)((Object)this.channel);
            ReadableByteChannel readableByteChannel = this.channel;
            synchronized (readableByteChannel) {
                int n;
                block14: {
                    SelectionKey key = null;
                    if (this.selector == null) {
                        this.selector = Selector.open();
                    }
                    try {
                        this.selector.selectNow();
                        schannel.configureBlocking(false);
                        key = schannel.register(this.selector, 1);
                        this.selector.select(this.timeoutMillis);
                        int rc = this.channel.read(buffer);
                        if (rc == 0) {
                            throw new IOException("Timeout waiting for read (" + this.timeoutMillis + " milliseconds)");
                        }
                        n = rc;
                        if (key == null) break block14;
                        key.cancel();
                    }
                    catch (Throwable throwable) {
                        if (key != null) {
                            key.cancel();
                        }
                        schannel.configureBlocking(true);
                        throw throwable;
                    }
                }
                schannel.configureBlocking(true);
                return n;
            }
        }
    }
}

