/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.types.impl;

import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.XSHexBinary;
import com.marklogic.xcc.types.impl.AbstractStringItem;

public class XsHexBinaryImpl
extends AbstractStringItem
implements XSHexBinary {
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public XsHexBinaryImpl(String bodyString) {
        super(ValueType.XS_HEX_BINARY, bodyString);
        this.validateHex(bodyString);
    }

    public XsHexBinaryImpl(byte[] body) {
        super(ValueType.XS_HEX_BINARY, XsHexBinaryImpl.convertBinaryToHex(body));
    }

    @Override
    public byte[] asBinaryData() {
        return this.convertHexToBinary(this.asString());
    }

    private void validateHex(String bodyString) {
        int len = bodyString.length();
        for (int i = 0; i < len; ++i) {
            char c = Character.toLowerCase(bodyString.charAt(i));
            if (Character.isDigit(c) || c >= 'a' && c <= 'f') continue;
            throw new IllegalArgumentException("Illegal character in hex string: '" + c + "', index=" + i);
        }
    }

    private byte[] convertHexToBinary(String hex) {
        int strLen = hex.length();
        byte[] binary = new byte[(strLen + 1) / 2];
        int binIdx = 0;
        for (int currIdx = 0; currIdx < strLen; currIdx += 2) {
            char hi = hex.charAt(currIdx);
            char lo = currIdx < strLen - 1 ? (char)hex.charAt(currIdx + 1) : (char)'0';
            int val = Character.digit(hi, 16) << 4 | Character.digit(lo, 16);
            binary[binIdx++] = (byte)(val & 0xFF);
        }
        return binary;
    }

    public static String convertBinaryToHex(byte[] binary) {
        char[] result = new char[binary.length * 2];
        int r = 0;
        for (byte b : binary) {
            result[r++] = hexDigits[(b & 0xF0) >> 4];
            result[r++] = hexDigits[b & 0xF];
        }
        return new String(result);
    }
}

