/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.types.impl;

import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.XdmItem;
import com.marklogic.xcc.types.XdmSequence;
import com.marklogic.xcc.types.XdmValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SequenceImpl
implements XdmSequence<XdmItem> {
    private List<XdmItem> items = new ArrayList<XdmItem>();

    public SequenceImpl(XdmValue[] values) {
        this.flattenValues(this.items, values);
    }

    private void flattenValues(List<XdmItem> items, XdmValue[] values) {
        for (int i = 0; i < values.length; ++i) {
            XdmValue value = values[i];
            if (value instanceof XdmSequence) {
                XdmSequence seq = (XdmSequence)value;
                this.flattenValues(items, seq.toArray());
                continue;
            }
            items.add((XdmItem)value);
        }
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public XdmItem[] toArray() {
        XdmItem[] array = new XdmItem[this.items.size()];
        this.items.toArray(array);
        return array;
    }

    @Override
    public XdmItem itemAt(int index) {
        return this.items.get(index);
    }

    @Override
    public Iterator<XdmItem> iterator() {
        return Collections.unmodifiableList(this.items).iterator();
    }

    @Override
    public String asString(String separator) {
        return SequenceImpl.asStringConcatenation(this, separator);
    }

    @Override
    public String asString() {
        return this.asString("\n");
    }

    @Override
    public String[] asStrings() {
        return SequenceImpl.asStringArray(this);
    }

    public static String asStringConcatenation(XdmSequence<?> sequence, String separator) {
        StringBuffer sb = new StringBuffer(512);
        String[] strings = sequence.asStrings();
        for (int i = 0; i < strings.length; ++i) {
            if (i != 0) {
                sb.append(separator);
            }
            sb.append(strings[i]);
        }
        return sb.substring(0);
    }

    public static String[] asStringArray(XdmSequence<?> sequence) {
        XdmItem[] items = sequence.toArray();
        String[] strings = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            strings[i] = items[i].asString();
        }
        return strings;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.SEQUENCE;
    }

    @Override
    public String toString() {
        return "XdmSequence: size=" + this.size();
    }
}

