/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.types.impl;

import com.marklogic.xcc.types.ItemType;
import com.marklogic.xcc.types.NumberNode;
import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.impl.JsonNodeImpl;
import java.io.InputStream;
import java.math.BigDecimal;

public class NumberNodeImpl
extends JsonNodeImpl
implements NumberNode {
    private final double value;
    private final BigDecimal bigDecimalValue;
    private final NumberFormatException formatException;

    public NumberNodeImpl(InputStream stream) {
        super((ItemType)ValueType.NUMBER_NODE, stream);
        this.value = Double.valueOf(this.scrubbedFloatValue(this.asString()));
        BigDecimal tmpBigDecimal = null;
        NumberFormatException tmpEx = null;
        try {
            tmpBigDecimal = new BigDecimal(this.asString());
        }
        catch (NumberFormatException e) {
            tmpEx = e;
        }
        this.bigDecimalValue = tmpBigDecimal;
        this.formatException = tmpEx;
    }

    public NumberNodeImpl(String stringVal) {
        super((ItemType)ValueType.NUMBER_NODE, stringVal);
        this.value = Double.valueOf(this.scrubbedFloatValue(stringVal));
        BigDecimal tmpBigDecimal = null;
        NumberFormatException tmpEx = null;
        try {
            tmpBigDecimal = new BigDecimal(stringVal);
        }
        catch (NumberFormatException e) {
            tmpEx = e;
        }
        this.bigDecimalValue = tmpBigDecimal;
        this.formatException = tmpEx;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public BigDecimal asBigDecimal() {
        if (this.bigDecimalValue == null) {
            throw this.formatException;
        }
        return this.bigDecimalValue;
    }

    String scrubbedFloatValue(String rawValue) {
        if (rawValue.equalsIgnoreCase("-INF")) {
            return "-Infinity";
        }
        if (rawValue.equalsIgnoreCase("+INF")) {
            return "+Infinity";
        }
        if (rawValue.equalsIgnoreCase("INF")) {
            return "Infinity";
        }
        return rawValue;
    }
}

