/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.types.impl;

import com.marklogic.io.IOHelper;
import com.marklogic.xcc.types.ItemType;
import com.marklogic.xcc.types.impl.AbstractItem;
import com.marklogic.xcc.types.impl.StreamableItem;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

public class AbstractStreamableItem
extends AbstractItem
implements StreamableItem {
    protected String stringVal = null;
    protected InputStream stream = null;

    public AbstractStreamableItem(ItemType type, String stringVal) {
        super(type);
        this.stringVal = stringVal;
    }

    public AbstractStreamableItem(ItemType type, InputStream stream) {
        super(type);
        this.stream = stream;
    }

    @Override
    public boolean isFetchable() {
        return this.stringVal != null || this.stream != null;
    }

    @Override
    public void invalidate() {
        this.stringVal = null;
        if (this.stream != null) {
            try {
                this.stream.skip(Long.MAX_VALUE);
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.stream = null;
        }
    }

    @Override
    public boolean isCached() {
        return this.stringVal != null;
    }

    @Override
    public Reader asReader() {
        if (this.stream != null) {
            InputStream tmp = this.stream;
            this.stream = null;
            try {
                return new InputStreamReader(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return new InputStreamReader(tmp);
            }
        }
        if (this.stringVal == null) {
            throw new IllegalStateException("value stream has already been consumed");
        }
        return new StringReader(this.stringVal);
    }

    @Override
    public InputStream asInputStream() {
        if (this.stream != null) {
            InputStream tmp = this.stream;
            this.stream = null;
            return tmp;
        }
        if (this.stringVal == null) {
            throw new IllegalStateException("value stream has already been consumed");
        }
        return IOHelper.newUtf8Stream(this.stringVal);
    }

    @Override
    public String asString() {
        if (this.stringVal != null) {
            return this.stringVal;
        }
        if (this.stream == null) {
            throw new IllegalStateException("value stream has already been consumed");
        }
        try {
            this.stringVal = IOHelper.literalStringFromStream(this.stream);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not buffer value as string", e);
        }
        finally {
            this.stream = null;
        }
        return this.stringVal;
    }
}

