/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.types;

import com.marklogic.xcc.types.AtomicType;
import com.marklogic.xcc.types.NodeType;
import com.marklogic.xcc.types.SequenceType;

public abstract class ValueType {
    private String name;
    public static final ValueType SEQUENCE = new SequenceType("(sequence)");
    public static final NodeType NODE = new NodeType("node()");
    public static final NodeType ELEMENT = new NodeType("element()");
    public static final NodeType DOCUMENT = new NodeType("document-node()");
    public static final NodeType TEXT = new NodeType("text()");
    public static final NodeType BINARY = new NodeType("binary()");
    public static final NodeType ATTRIBUTE = new NodeType("attribute()");
    public static final NodeType PROCESSING_INSTRUCTION = new NodeType("processing-instruction()");
    public static final NodeType COMMENT = new NodeType("comment()");
    public static final NodeType OBJECT_NODE = new NodeType("object-node()");
    public static final NodeType NULL_NODE = new NodeType("null-node()");
    public static final NodeType BOOLEAN_NODE = new NodeType("boolean-node()");
    public static final NodeType ARRAY_NODE = new NodeType("array-node()");
    public static final NodeType NUMBER_NODE = new NodeType("number-node()");
    public static final AtomicType XS_UNTYPED_ATOMIC = new AtomicType("xs:untypedAtomic");
    public static final AtomicType XS_STRING = new AtomicType("xs:string");
    public static final AtomicType XS_BOOLEAN = new AtomicType("xs:boolean");
    public static final AtomicType XS_INTEGER = new AtomicType("xs:integer");
    public static final AtomicType XS_DECIMAL = new AtomicType("xs:decimal");
    public static final AtomicType XS_FLOAT = new AtomicType("xs:float");
    public static final AtomicType XS_DOUBLE = new AtomicType("xs:double");
    public static final AtomicType XS_DURATION = new AtomicType("xs:duration");
    public static final AtomicType XS_DAY_TIME_DURATION = new AtomicType("xs:dayTimeDuration");
    public static final AtomicType XS_YEAR_MONTH_DURATION = new AtomicType("xs:yearMonthDuration");
    public static final AtomicType XS_DATE_TIME = new AtomicType("xs:dateTime");
    public static final AtomicType XS_TIME = new AtomicType("xs:time");
    public static final AtomicType XS_DATE = new AtomicType("xs:date");
    public static final AtomicType XS_ANY_URI = new AtomicType("xs:anyURI");
    public static final AtomicType XS_QNAME = new AtomicType("xs:QName");
    public static final AtomicType XS_GDAY = new AtomicType("xs:gDay");
    public static final AtomicType XS_GMONTH = new AtomicType("xs:gMonth");
    public static final AtomicType XS_GMONTH_DAY = new AtomicType("xs:gMonthDay");
    public static final AtomicType XS_GYEAR = new AtomicType("xs:gYear");
    public static final AtomicType XS_GYEAR_MONTH = new AtomicType("xs:gYearMonth");
    public static final AtomicType XS_HEX_BINARY = new AtomicType("xs:hexBinary");
    public static final AtomicType XS_BASE64_BINARY = new AtomicType("xs:base64Binary");
    public static final AtomicType CTS_BOX = new AtomicType("cts:box");
    public static final AtomicType CTS_CIRCLE = new AtomicType("cts:circle");
    public static final AtomicType CTS_POINT = new AtomicType("cts:point");
    public static final AtomicType CTS_POLYGON = new AtomicType("cts:polygon");
    public static final AtomicType JS_ARRAY = new AtomicType("json:array");
    public static final AtomicType JS_OBJECT = new AtomicType("json:object");
    public static final AtomicType JS_NULL = new AtomicType("json:null");

    ValueType(String name) {
        this.name = name;
    }

    public abstract boolean isSequence();

    public String toString() {
        return this.name;
    }

    public static final ValueType valueOf(String name) {
        if (name.startsWith("xs:")) {
            if (name.equals("xs:untypedAtomic")) {
                return XS_UNTYPED_ATOMIC;
            }
            if (name.equals("xs:string")) {
                return XS_STRING;
            }
            if (name.equals("xs:boolean")) {
                return XS_BOOLEAN;
            }
            if (name.equals("xs:integer")) {
                return XS_INTEGER;
            }
            if (name.equals("xs:decimal")) {
                return XS_DECIMAL;
            }
            if (name.equals("xs:float")) {
                return XS_FLOAT;
            }
            if (name.equals("xs:double")) {
                return XS_DOUBLE;
            }
            if (name.equals("xs:duration")) {
                return XS_DURATION;
            }
            if (name.equals("xs:dayTimeDuration")) {
                return XS_DAY_TIME_DURATION;
            }
            if (name.equals("xs:yearMonthDuration")) {
                return XS_YEAR_MONTH_DURATION;
            }
            if (name.equals("xs:dateTime")) {
                return XS_DATE_TIME;
            }
            if (name.equals("xs:time")) {
                return XS_TIME;
            }
            if (name.equals("xs:date")) {
                return XS_DATE;
            }
            if (name.equals("xs:anyURI")) {
                return XS_ANY_URI;
            }
            if (name.equals("xs:QName")) {
                return XS_QNAME;
            }
            if (name.equals("xs:gDay")) {
                return XS_GDAY;
            }
            if (name.equals("xs:gMonth")) {
                return XS_GMONTH;
            }
            if (name.equals("xs:gMonthDay")) {
                return XS_GMONTH_DAY;
            }
            if (name.equals("xs:gYear")) {
                return XS_GYEAR;
            }
            if (name.equals("xs:gYearMonth")) {
                return XS_GYEAR_MONTH;
            }
            if (name.equals("xs:hexBinary")) {
                return XS_HEX_BINARY;
            }
            if (name.equals("xs:base64Binary")) {
                return XS_BASE64_BINARY;
            }
            throw new IllegalArgumentException("Illegal value type: " + name);
        }
        if (name.startsWith("cts:")) {
            if (name.equals("cts:box")) {
                return CTS_BOX;
            }
            if (name.equals("cts:circle")) {
                return CTS_CIRCLE;
            }
            if (name.equals("cts:point")) {
                return CTS_POINT;
            }
            if (name.equals("cts:polygon")) {
                return CTS_POLYGON;
            }
            throw new IllegalArgumentException("Illegal value type: " + name);
        }
        if (name.startsWith("json")) {
            if (name.equals("json:object")) {
                return JS_OBJECT;
            }
            if (name.equals("json:array")) {
                return JS_ARRAY;
            }
            if (name.equals("json:null")) {
                return JS_NULL;
            }
            throw new IllegalArgumentException("Illegal value type: " + name);
        }
        if (name.endsWith("()")) {
            if (name.equals("node()")) {
                return NODE;
            }
            if (name.equals("element()")) {
                return ELEMENT;
            }
            if (name.equals("document-node()")) {
                return DOCUMENT;
            }
            if (name.equals("text()")) {
                return TEXT;
            }
            if (name.equals("binary()")) {
                return BINARY;
            }
            if (name.equals("attribute()")) {
                return ATTRIBUTE;
            }
            if (name.equals("processing-instruction()")) {
                return PROCESSING_INSTRUCTION;
            }
            if (name.equals("comment()")) {
                return new NodeType(name);
            }
            if (name.equals("object-node()")) {
                return OBJECT_NODE;
            }
            if (name.equals("array-node()")) {
                return ARRAY_NODE;
            }
            if (name.equals("null-node()")) {
                return NULL_NODE;
            }
            if (name.equals("number-node()")) {
                return NUMBER_NODE;
            }
            if (name.equals("boolean-node()")) {
                return BOOLEAN_NODE;
            }
            throw new IllegalArgumentException("Illegal value type: " + name);
        }
        if (name.equals("(sequence)")) {
            return SEQUENCE;
        }
        throw new IllegalArgumentException("Illegal value type: " + name);
    }
}

