/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl.handlers;

import com.marklogic.http.HttpChannel;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.UserCredentials;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.RequestPermissionException;
import com.marklogic.xcc.exceptions.ServerResponseException;
import com.marklogic.xcc.impl.ContentSourceImpl;
import com.marklogic.xcc.impl.handlers.ResponseHandler;
import java.io.IOException;
import java.util.logging.Logger;

public class UnauthorizedHandler
implements ResponseHandler {
    @Override
    public Object handleResponse(HttpChannel http, int responseCode, Request request, Object attachment, Logger logger) throws RequestException {
        String challenge;
        try {
            challenge = http.getResponseHeader("www-authenticate");
        }
        catch (IOException e) {
            throw new ServerResponseException("Failed checking authenticate header.", request, responseCode, this.getResponseMessage(http), e);
        }
        ContentSourceImpl contentSource = (ContentSourceImpl)request.getSession().getContentSource();
        contentSource.setAuthChallenge(challenge);
        String requestAuth = http.getRequestHeader("Authorization");
        boolean retryAdvised = !contentSource.isChallengeIgnored() && !contentSource.isAuthenticationPreemptive() && (requestAuth == null || !challenge.regionMatches(true, 0, requestAuth, 0, 6));
        UserCredentials credentials = request.getSession().getUserCredentials();
        String userName = credentials.getUserName();
        String message = "Authorization failed for user '" + userName + "'.";
        throw new RequestPermissionException(message, request, userName, retryAdvised);
    }

    private String getResponseMessage(HttpChannel http) {
        try {
            return http.getResponseMessage();
        }
        catch (IOException e) {
            return "No Message";
        }
    }
}

