/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.ArrayList;
import java.util.List;

public class MockHttpServer {
    private static final int DEFAULT_BUF_SIZE = 100000;
    private ByteBuffer request;
    private List<Object> responses = new ArrayList<Object>();

    public MockHttpServer(byte[] reply, int bufSize) {
        if (reply != null) {
            this.addReply(reply);
        }
        this.request = ByteBuffer.allocate(bufSize);
    }

    public MockHttpServer(byte[] reply) {
        this(reply, 100000);
    }

    public MockHttpServer(int bufSize) {
        this(null, bufSize);
    }

    public MockHttpServer() {
        this(null, 100000);
    }

    public void clearReplies() {
        this.responses.clear();
    }

    public void addReply(byte[] reply) {
        this.responses.add(ByteBuffer.wrap(reply));
    }

    public ByteChannel getChannel() {
        if (this.responses.size() == 0) {
            ByteBuffer response = ByteBuffer.allocate(1);
            response.flip();
            return new MockSocketChannel(this.request, response);
        }
        Object obj = this.responses.remove(0);
        if (obj instanceof ByteBuffer) {
            return new MockSocketChannel(this.request, (ByteBuffer)obj);
        }
        return new MockSocketChannel(this.request, (IOException)obj);
    }

    public ByteBuffer getCurrentRequestBuffer() {
        ByteBuffer buf = this.request.duplicate();
        buf.flip();
        return buf;
    }

    public String getCurrentRequestBufferAsString() {
        ByteBuffer buf = this.getCurrentRequestBuffer();
        return new String(buf.array(), buf.arrayOffset(), buf.limit());
    }

    public String getCurrentRequestBufferBodyAsString() {
        String buffer = this.getCurrentRequestBufferAsString();
        return buffer.substring(buffer.indexOf("\r\n\r\n") + 4);
    }

    public void addError(IOException e) {
        this.responses.add(e);
    }

    private static class MockSocketChannel
    implements ByteChannel {
        private final ByteBuffer requestBuffer;
        private final ByteBuffer responseBuffer;
        private final IOException exception;
        private boolean open = true;

        public MockSocketChannel(ByteBuffer requestBuffer, ByteBuffer responseBuffer) {
            this.requestBuffer = requestBuffer;
            this.responseBuffer = responseBuffer;
            this.exception = null;
        }

        public MockSocketChannel(ByteBuffer requestBuffer, IOException exception) {
            this.requestBuffer = requestBuffer;
            this.exception = exception;
            this.responseBuffer = null;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
            int count = 0;
            while (this.responseBuffer.hasRemaining() && dst.hasRemaining()) {
                dst.put(this.responseBuffer.get());
                ++count;
            }
            return count == 0 ? -1 : count;
        }

        @Override
        public boolean isOpen() {
            return this.open;
        }

        @Override
        public void close() throws IOException {
            this.open = false;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int count = 0;
            while (src.hasRemaining() && this.requestBuffer.hasRemaining()) {
                this.requestBuffer.put(src.get());
                ++count;
            }
            return count;
        }
    }
}

