/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.jndi;

import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentSourceFactory;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.XccConfigException;
import com.marklogic.xcc.spi.ConnectionProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;

public class ContentSourceBean
implements ContentSource {
    private ContentSource cs = null;
    private String host = null;
    private int port = 0;
    private String user = null;
    private String password = null;
    private String contentBase = null;
    private URI url = null;
    private boolean authenticationPreemptive = false;

    @Override
    public Session newSession() {
        return this.getContentSource().newSession();
    }

    @Override
    public Session newSession(String databaseId) {
        return this.getContentSource().newSession(databaseId);
    }

    @Override
    public Session newSession(String userName, String password) {
        return this.getContentSource().newSession(userName, password);
    }

    @Override
    public Session newSession(String userName, String password, String databaseId) {
        return this.getContentSource().newSession(userName, password, databaseId);
    }

    @Override
    public Logger getDefaultLogger() {
        return this.getContentSource().getDefaultLogger();
    }

    @Override
    public void setDefaultLogger(Logger logger) {
        this.getContentSource().setDefaultLogger(logger);
    }

    @Override
    public ConnectionProvider getConnectionProvider() {
        return this.getContentSource().getConnectionProvider();
    }

    public String toString() {
        return this.getContentSource().toString();
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setContentBase(String contentBase) {
        this.contentBase = contentBase;
    }

    public void setUrl(String url) throws URISyntaxException {
        this.url = new URI(url);
    }

    @Override
    public boolean isAuthenticationPreemptive() {
        return this.authenticationPreemptive;
    }

    @Override
    public void setAuthenticationPreemptive(boolean value) {
        this.authenticationPreemptive = value;
    }

    private ContentSource getContentSource() {
        if (this.cs != null) {
            return this.cs;
        }
        if (this.url == null) {
            this.cs = ContentSourceFactory.newContentSource(this.host, this.port, this.user, this.password, this.contentBase);
        } else {
            try {
                this.cs = ContentSourceFactory.newContentSource(this.url);
            }
            catch (XccConfigException e) {
                throw new IllegalArgumentException("Cannot create ContentSource from URI", e);
            }
        }
        this.cs.setAuthenticationPreemptive(this.authenticationPreemptive);
        return this.cs;
    }

    @Override
    public Session newSession(String userName, char[] password) {
        return this.getContentSource().newSession(userName, password);
    }

    @Override
    public Session newSession(String userName, char[] password, String contentbaseId) {
        return this.getContentSource().newSession(userName, password, contentbaseId);
    }
}

