/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.io;

import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private static final String nl = System.getProperty("line.separator");
    private static final String DEFUALT_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private final SimpleDateFormat fmt;
    private final StringBuffer dateSb = new StringBuffer(512);
    private final FieldPosition fpos = new FieldPosition(0);
    private final StringBuffer sb = new StringBuffer(512);
    private final boolean showTime;
    private final boolean showLevel;
    private final boolean showThread;
    private final boolean showLocation;

    public LogFormatter(Properties props, LogManager lm) {
        String className = this.getClass().getName();
        this.fmt = new SimpleDateFormat(this.getProperty(props, lm, className + ".time-format", DEFUALT_TIME_FORMAT));
        this.showTime = this.getBoolean(props, lm, className + ".show-time", true);
        this.showLevel = this.getBoolean(props, lm, className + ".show-level", true);
        this.showThread = this.getBoolean(props, lm, className + ".show-thread", true);
        this.showLocation = this.getBoolean(props, lm, className + ".show-location", true);
    }

    public LogFormatter() {
        this(null, LogManager.getLogManager());
    }

    @Override
    public synchronized String format(LogRecord record) {
        String pad = "";
        this.sb.setLength(0);
        if (this.showTime) {
            this.sb.append(pad).append(this.formatTime(record));
            pad = " ";
        }
        if (this.showLevel) {
            this.sb.append(pad).append(record.getLevel());
            pad = " ";
        }
        if (this.showThread) {
            this.sb.append(pad).append("[").append(record.getThreadID()).append("]");
            pad = " ";
        }
        if (this.showLocation) {
            this.sb.append(pad).append("(").append(this.formatLocation(record)).append(")");
            pad = " ";
        }
        this.sb.append(": ").append(record.getMessage()).append(nl);
        Throwable t = record.getThrown();
        if (t == null) {
            return this.sb.toString();
        }
        StackTraceElement[] elements = t.getStackTrace();
        this.sb.append(" ").append(t.toString()).append(nl);
        for (int i = 0; i < elements.length; ++i) {
            StackTraceElement element = elements[i];
            this.sb.append("\t").append(element.toString()).append(nl);
        }
        return this.sb.toString();
    }

    private String formatLocation(LogRecord record) {
        String className = record.getSourceClassName();
        int idx = className.lastIndexOf(".");
        if (idx != -1) {
            className = className.substring(idx + 1);
        }
        return className + "." + record.getSourceMethodName();
    }

    private String formatTime(LogRecord record) {
        this.dateSb.setLength(0);
        return this.fmt.format(new Date(record.getMillis()), this.dateSb, this.fpos).toString();
    }

    private boolean getBoolean(Properties props, LogManager lm, String property, boolean defaultValue) {
        String value = this.getProperty(props, lm, property, null);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Boolean.valueOf(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private String getProperty(Properties props, LogManager lm, String property, String defaultValue) {
        String value;
        String string = value = props == null ? null : props.getProperty(property);
        if (value != null) {
            return value;
        }
        value = lm.getProperty(property);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

