/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl;

import com.marklogic.http.HttpChannel;
import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentbaseMetaData;
import com.marklogic.xcc.ModuleInvoke;
import com.marklogic.xcc.ModuleSpawn;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultItem;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.UserCredentials;
import com.marklogic.xcc.Version;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.StreamingResultException;
import com.marklogic.xcc.exceptions.XQueryException;
import com.marklogic.xcc.impl.AdhocImpl;
import com.marklogic.xcc.impl.CBMetaDataImpl;
import com.marklogic.xcc.impl.Credentials;
import com.marklogic.xcc.impl.ModuleImpl;
import com.marklogic.xcc.impl.RequestImpl;
import com.marklogic.xcc.impl.SSLSocketPoolProvider;
import com.marklogic.xcc.impl.StreamingResultSequence;
import com.marklogic.xcc.impl.XAResourceImpl;
import com.marklogic.xcc.impl.handlers.ContentInsertController;
import com.marklogic.xcc.impl.handlers.EvalRequestController;
import com.marklogic.xcc.spi.ConnectionProvider;
import com.marklogic.xcc.spi.SingleHostAddress;
import com.marklogic.xcc.types.XSDecimal;
import com.marklogic.xcc.types.XSInteger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.HttpCookie;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;

public class SessionImpl
implements Session {
    private final Set<StreamingResultSequence> activeResultSeqs;
    private final ContentSource contentSource;
    private final ConnectionProvider provider;
    private final UserCredentials credentials;
    private final String contentBase;
    private final String basePath;
    private XAResourceImpl xaResource = null;
    private Logger logger = null;
    private RequestOptions defaultOptions = new RequestOptions();
    String sessionID = null;
    String txnID = null;
    private Session.TransactionMode txnMode = null;
    private boolean commitMode = false;
    private Session.TransactionMode userSpecifiedTxnMode = null;
    private int timeout = 0;
    private boolean closed = false;
    boolean inXATxn = false;
    private Object userObject = null;
    private String serverVersion = null;
    private Throwable created = new Throwable();
    private boolean compatibleTxnMode = System.getProperty("xcc.txn.compatible", "false").equals("true");
    private Boolean txnIncompatible = null;
    private boolean txnModeChanged = false;
    private static final boolean envCompactSequencesEnabled = System.getProperty("xcc.compact.sequences", "true").equals("true");
    private boolean compactSequencesEnabled = envCompactSequencesEnabled;
    private static final String agentString = "Java/" + System.getProperty("java.version") + " MarkLogicXCC/" + Version.getVersionMajor() + "." + Version.getVersionMinor() + "-" + Version.getVersionPatch();
    private Map<String, HttpCookie> cookieJar = null;
    private StringBuilder requestCookies = null;

    public boolean isCompactSequencesEnabled() {
        return this.compactSequencesEnabled;
    }

    public void setCompactSequencesEnabled(boolean compactSequencesEnabled) {
        this.compactSequencesEnabled = compactSequencesEnabled;
    }

    public SessionImpl(ContentSource contentSource, ConnectionProvider connectionProvider, UserCredentials credentials, String contentBase, String basePath) {
        this.contentSource = contentSource;
        this.provider = connectionProvider;
        this.credentials = credentials;
        this.contentBase = contentBase;
        this.basePath = basePath;
        this.activeResultSeqs = Collections.synchronizedSet(new HashSet());
    }

    public SessionImpl clone() {
        return new SessionImpl(this.contentSource, this.provider, this.credentials, this.contentBase, this.basePath);
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public UserCredentials getUserCredentials() {
        return this.credentials;
    }

    @Override
    public String getContentBaseName() {
        return this.contentBase;
    }

    @Override
    public ContentSource getContentSource() {
        return this.contentSource;
    }

    @Override
    public XAResource getXAResource() {
        if (this.xaResource == null) {
            this.xaResource = new XAResourceImpl(this);
        }
        return this.xaResource;
    }

    @Override
    public void setTransactionMode(Session.TransactionMode mode) {
        if (this.getTxnID() != null) {
            this.throwIllegalState("Cannot call setTransactionMode() when there is an active transaction");
        }
        if (this.commitMode) {
            this.throwIllegalState("Cannot call setTransactionMode() in combination with setAutoCommit() or setUpdate().");
        }
        this.txnMode = mode;
        this.txnModeChanged = true;
    }

    @Override
    public Session.TransactionMode getTransactionMode() {
        return this.txnMode;
    }

    @Override
    public boolean isAutoCommit() {
        return this.txnMode == null ? true : this.txnMode.isAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        this.commitMode = true;
        if (this.txnMode == null) {
            this.txnMode = autoCommit ? Session.TransactionMode.AUTO : Session.TransactionMode.MULTI_AUTO;
            return;
        }
        if (autoCommit == this.txnMode.isAutoCommit()) {
            return;
        }
        if (this.getTxnID() != null) {
            this.throwIllegalState("Cannot change transaction's autoCommit when there is an active transaction");
        }
        this.txnMode = this.txnMode.setAutoCommit(autoCommit);
    }

    @Override
    public void setTransactionTimeout(int seconds) throws RequestException {
        if (this.getTxnID() != null) {
            this.submitRequestInternal(new AdhocImpl(this, "xquery version '1.0-ml';\nxdmp:set-transaction-time-limit(" + seconds + ")", null)).close();
        }
        this.timeout = seconds;
    }

    @Override
    public int getTransactionTimeout() throws RequestException {
        if (this.getTxnID() != null) {
            try (ResultSequence rs = this.submitRequestInternal(new AdhocImpl(this, "xquery version '1.0-ml';\nxdmp:host-status(xdmp:host())//*:transaction[*:transaction-id eq xdmp:transaction()]/*:time-limit/string()", null));){
                this.timeout = Integer.parseInt(rs.next().asString());
            }
        }
        return this.timeout;
    }

    public int getCachedTransactionTimeout() {
        return this.timeout;
    }

    @Override
    public boolean commit() throws RequestException {
        this.assertSessionOpen();
        if (this.getTxnID() != null) {
            this.submitRequestInternal(new AdhocImpl(this, "xquery version '1.0-ml'; xdmp:commit()", null)).close();
            return true;
        }
        return false;
    }

    @Override
    public void rollback() throws RequestException {
        this.assertSessionOpen();
        if (this.getTxnID() != null) {
            this.submitRequestInternal(new AdhocImpl(this, "xquery version '1.0-ml'; xdmp:rollback()", null)).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        boolean doRollback = false;
        Object object = this;
        synchronized (object) {
            doRollback = !this.inXATxn && this.txnID != null;
        }
        if (doRollback) {
            try {
                this.rollback();
            }
            catch (XQueryException e) {
                if (!e.equals("XDMP-NOTXN")) {
                    this.getLogger().log(Level.INFO, "Exception rolling back during Session.close()", e);
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.INFO, "Exception rolling back during Session.close()", e);
            }
        }
        this.closed = true;
        object = this.activeResultSeqs;
        synchronized (object) {
            Iterator<StreamingResultSequence> it = this.activeResultSeqs.iterator();
            while (it.hasNext()) {
                StreamingResultSequence rs = it.next();
                it.remove();
                try {
                    rs.close();
                }
                catch (StreamingResultException e) {
                    this.getLogger().log(Level.WARNING, "Exception closing streaming result sequence.", e);
                }
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void finalize() {
        try {
            if (!this.closed) {
                if (this.getTxnID() != null) {
                    this.getLogger().log(Level.SEVERE, "Destructing Session object with open transaction " + this.getTxnID() + ": ", this.created);
                }
                this.close();
            }
        }
        catch (Throwable t) {
            this.getLogger().log(Level.SEVERE, "Exception during SessionImpl.finalize()", t);
        }
    }

    @Override
    public ModuleInvoke newModuleInvoke(String moduleUri, RequestOptions options) {
        this.assertSessionOpen();
        return new ModuleImpl(this, moduleUri, options, false);
    }

    @Override
    public ModuleInvoke newModuleInvoke(String moduleUri) {
        return this.newModuleInvoke(moduleUri, null);
    }

    @Override
    public ModuleSpawn newModuleSpawn(String moduleUri, RequestOptions options) {
        this.assertSessionOpen();
        return new ModuleImpl(this, moduleUri, options, true);
    }

    @Override
    public ModuleSpawn newModuleSpawn(String moduleUri) {
        return this.newModuleSpawn(moduleUri, null);
    }

    @Override
    public AdhocQuery newAdhocQuery(String queryText, RequestOptions options) {
        this.assertSessionOpen();
        return new AdhocImpl(this, queryText, options);
    }

    @Override
    public AdhocQuery newAdhocQuery(String queryText) {
        this.assertSessionOpen();
        return this.newAdhocQuery(queryText, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertContent(Content[] contents) throws RequestException {
        boolean startTxn = contents != null && contents.length > 1 && HttpChannel.isUseHTTP() && this.isAutoCommit() && this.txnID == null;
        Session.TransactionMode origMode = this.txnMode;
        if (startTxn) {
            this.setAutoCommit(false);
        }
        try {
            this.insertContent(contents, false);
        }
        finally {
            if (startTxn && this.getTxnID() != null) {
                this.commit();
                this.txnMode = origMode;
            }
        }
    }

    @Override
    public List<RequestException> insertContentCollectErrors(Content[] contents) throws RequestException {
        return this.insertContent(contents, true);
    }

    public List<RequestException> insertContent(Content[] contents, boolean collectErrors) throws RequestException {
        this.assertSessionOpen();
        AdhocQuery request = this.newAdhocQuery("()");
        RequestOptions sessionOptions = this.getDefaultRequestOptions();
        if (sessionOptions.getMaxAutoRetry() == -1 || sessionOptions.getAutoRetryDelayMillis() == -1) {
            RequestOptions options = new RequestOptions();
            if (sessionOptions.getMaxAutoRetry() == -1) {
                options.setMaxAutoRetry(64);
            }
            if (sessionOptions.getAutoRetryDelayMillis() == -1) {
                options.setAutoRetryDelayMillis(125);
            }
            if (this.getTxnID() != null) {
                options.setMaxAutoRetry(0);
            }
            request.setOptions(options);
        }
        this.assertNoTimeStamp(request);
        this.assertNonEmptyUris(request, contents);
        this.createTransaction(request);
        ContentInsertController controller = new ContentInsertController(contents, this.txnMode, collectErrors, this.basePath);
        controller.runRequest(this.provider, request, this.getLogger());
        return controller.getErrors();
    }

    public boolean isInCompatibleMode() {
        return this.compatibleTxnMode;
    }

    public void setCompatibleMode(boolean mode) {
        this.compatibleTxnMode = mode;
    }

    private void createTransaction(Request request) throws RequestException {
        if (this.getTxnID() == null && this.txnMode != null || this.txnModeChanged) {
            if (this.commitMode) {
                this.userSpecifiedTxnMode = this.txnMode;
            }
            if (this.compatibleTxnMode && this.txnMode != Session.TransactionMode.AUTO) {
                RequestOptions options = new RequestOptions();
                RequestOptions reqOpt = request.getOptions();
                options.setAutoRetryDelayMillis(reqOpt.getAutoRetryDelayMillis());
                options.setMaxAutoRetry(reqOpt.getMaxAutoRetry());
                options.setRequestName(reqOpt.getRequestName());
                options.setRequestTimeLimit(reqOpt.getRequestTimeLimit());
                options.setTimeoutMillis(reqOpt.getTimeoutMillis());
                options.setTimeZone(reqOpt.getTimeZone());
                this.submitRequestInternal(new AdhocImpl(this, "xquery version '1.0-ml';\ndeclare option xdmp:transaction-mode '" + this.serializeTransactionMode(this.txnMode) + "'; " + (this.timeout == 0 || this.getTxnID() != null ? "()" : "xdmp:set-transaction-time-limit(" + this.timeout + ")"), options)).close();
            }
        }
    }

    private String serializeTransactionMode(Session.TransactionMode mode) {
        switch (mode) {
            case AUTO: {
                return "auto";
            }
            case QUERY: {
                return "query";
            }
            case UPDATE: {
                return "update";
            }
            case UPDATE_AUTO_COMMIT: {
                this.throwIllegalArg("Transaction mode UPDATE_AUTO_COMMIT is not supported when xcc.txn.compatible is set to true", this.getLogger());
                break;
            }
        }
        this.throwIllegalArg("Unknown transaction mode: should be TransactionMode.AUTO, TransactionMode.QUERY, TransactionMode.UPDATE", this.getLogger());
        return null;
    }

    private void assertNonEmptyUris(Request request, Content[] contents) throws RequestException {
        for (int i = 0; i < contents.length; ++i) {
            String uri = contents[i].getUri();
            if (uri != null && uri.length() != 0) continue;
            throw new RequestException("Content insertion with empty URI is not allowed", request);
        }
    }

    private void assertNoTimeStamp(Request request) throws RequestException {
        RequestOptions options = this.getEffectiveRequestOptions();
        if (options.getEffectivePointInTime() == null) {
            return;
        }
        if (options.getEffectivePointInTime().equals(BigInteger.ZERO)) {
            return;
        }
        throw new RequestException("Content insertion not allowed with non-zero Point-In-Time", request);
    }

    @Override
    public void insertContent(Content content) throws RequestException {
        this.insertContent(new Content[]{content});
    }

    @Override
    public ContentbaseMetaData getContentbaseMetaData() {
        return new CBMetaDataImpl(this);
    }

    @Override
    public void setDefaultRequestOptions(RequestOptions options) {
        this.defaultOptions = options == null ? new RequestOptions() : options;
    }

    @Override
    public RequestOptions getDefaultRequestOptions() {
        return this.defaultOptions;
    }

    @Override
    public Logger getLogger() {
        return this.logger == null ? this.contentSource.getDefaultLogger() : this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public ResultSequence submitRequest(Request request) throws RequestException {
        this.assertSessionOpen();
        if (request.getSession() != this || !(request instanceof RequestImpl)) {
            this.throwIllegalArg("Request object was not created by this session", this.getLogger());
        }
        this.createTransaction(request);
        return this.submitRequestInternal((RequestImpl)request);
    }

    ResultSequence submitRequestInternal(RequestImpl req) throws RequestException {
        EvalRequestController controller = new EvalRequestController(req.serverPath(), this.basePath, req.encodedQueryString(this.getLogger()));
        return controller.runRequest(this.provider, req, this.getLogger());
    }

    @Override
    public BigInteger getCurrentServerPointInTime() throws RequestException {
        AdhocQuery pitReq = this.newAdhocQuery("xdmp:request-timestamp()");
        ResultSequence rs = this.submitRequest(pitReq);
        ResultItem item = rs.next();
        BigInteger stamp = null;
        stamp = item.getItem() instanceof XSDecimal ? ((XSDecimal)item.getItem()).asBigDecimal().toBigInteger() : ((XSInteger)item.getItem()).asBigInteger();
        rs.close();
        return stamp;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public URI getConnectionUri() {
        if (!(this.provider instanceof SingleHostAddress)) {
            return null;
        }
        String scheme = this.provider instanceof SSLSocketPoolProvider ? "xccs" : "xcc";
        String contentBase = this.getContentBaseName() == null ? null : "/" + this.getContentBaseName();
        InetSocketAddress addr = ((SingleHostAddress)((Object)this.provider)).getAddress();
        Credentials.PDCloudAuthConfig pdCloudAuthConfig = this.getUserCredentials().getPDCloudAuthConfig();
        try {
            String basePathEncoded;
            String string = basePathEncoded = this.basePath == null ? null : URLEncoder.encode(this.basePath, "UTF-8");
            if (pdCloudAuthConfig != null) {
                String apiKeyEncoded = URLEncoder.encode(new String(pdCloudAuthConfig.getApiKey()), "UTF-8");
                String tokenEndpointEncoded = URLEncoder.encode(pdCloudAuthConfig.getTokenEndpoint(), "UTF-8");
                String grantTypeEncoded = URLEncoder.encode(pdCloudAuthConfig.getGrantType(), "UTF-8");
                String query = "basepath=" + basePathEncoded + "&apikey=xxxx&tokenendpoint=" + tokenEndpointEncoded + "&granttype=" + grantTypeEncoded + "&tokenduration=" + pdCloudAuthConfig.getTokenDuration();
                return new URI(scheme, null, addr.getHostName(), addr.getPort(), contentBase, query, null);
            }
            return new URI("xcc", this.getUserCredentials().getUserName() + ":xxxx", addr.getHostName(), addr.getPort(), contentBase, basePathEncoded == null ? null : "basepath=" + basePathEncoded, null);
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            return null;
        }
    }

    public void registerResultSequence(StreamingResultSequence resultSequence) {
        this.activeResultSeqs.add(resultSequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deRegisterResultSequence(StreamingResultSequence resultSequence) {
        Set<StreamingResultSequence> set = this.activeResultSeqs;
        synchronized (set) {
            if (this.activeResultSeqs.contains(resultSequence)) {
                this.activeResultSeqs.remove(resultSequence);
            }
        }
    }

    @Override
    public RequestOptions getEffectiveRequestOptions() {
        RequestOptions eff = new RequestOptions();
        RequestOptions ses = this.getDefaultRequestOptions();
        eff.applyEffectiveValues(new RequestOptions[]{ses});
        return eff;
    }

    public ConnectionProvider getProvider() {
        return this.provider;
    }

    public String userAgentString() {
        return agentString;
    }

    public synchronized String getSessionID() {
        return this.sessionID;
    }

    public synchronized String getTxnID() {
        return this.txnID;
    }

    public String getAcceptedContentTypes() {
        if (this.compactSequencesEnabled) {
            return "application/vnd.marklogic.sequence, */*";
        }
        return "*/*";
    }

    public boolean readCookieValues(HttpChannel http) throws IOException {
        List<String> cookies = http.getResponseHeaders("set-cookie");
        String mode = null;
        if (cookies != null) {
            if (this.cookieJar == null) {
                this.cookieJar = new HashMap<String, HttpCookie>();
            }
            for (String cookieString : cookies) {
                block11: for (HttpCookie cookie : HttpCookie.parse("Set-Cookie: " + cookieString)) {
                    switch (cookie.getName()) {
                        case "SessionID": {
                            this.sessionID = cookie.getValue();
                            continue block11;
                        }
                        case "TxnID": {
                            String txn = cookie.getValue();
                            this.txnID = txn.equals("null") ? null : txn;
                            continue block11;
                        }
                        case "TxnMode": {
                            mode = cookie.getValue();
                            continue block11;
                        }
                    }
                    this.cookieJar.put(cookie.getName(), cookie);
                }
            }
        }
        Session.TransactionMode newMode = null;
        if (mode != null) {
            newMode = this.parseTransactionMode(mode);
        }
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().fine("Receiving SessionID: " + this.sessionID + ", TxnID: " + this.txnID + ", TxnMode: " + (Object)((Object)newMode) + ", userSpecifiedTxnMode: " + (Object)((Object)this.userSpecifiedTxnMode));
        }
        if (this.txnIncompatible == null) {
            this.txnIncompatible = this.isTxnIncompatible();
        }
        if (this.txnMode != null && this.txnMode != Session.TransactionMode.AUTO && this.txnIncompatible.booleanValue()) {
            this.compatibleTxnMode = true;
            return false;
        }
        if (mode != null) {
            if (this.commitMode) {
                if (this.txnID != null) {
                    this.txnMode = newMode;
                } else if (this.userSpecifiedTxnMode != null) {
                    this.txnMode = this.userSpecifiedTxnMode;
                }
            } else {
                this.txnMode = newMode;
            }
            this.txnModeChanged = false;
        } else if (this.commitMode && this.userSpecifiedTxnMode != null) {
            this.txnMode = this.userSpecifiedTxnMode;
        }
        return true;
    }

    public void addRequestCookie(HttpCookie cookie) {
        if (this.requestCookies == null) {
            this.requestCookies = new StringBuilder();
        }
        if (cookie != null) {
            this.requestCookies.append(cookie.toString());
            this.requestCookies.append("; ");
        }
    }

    public void writeCookies(HttpChannel http) {
        this.requestCookies = null;
        if (this.cookieJar != null) {
            Iterator<Map.Entry<String, HttpCookie>> it = this.cookieJar.entrySet().iterator();
            while (it.hasNext()) {
                HttpCookie cookie = it.next().getValue();
                if (cookie.hasExpired()) {
                    it.remove();
                    continue;
                }
                this.addRequestCookie(cookie);
            }
            if (this.sessionID != null) {
                this.addRequestCookie(new HttpCookie("SessionID", this.sessionID));
            }
            if (this.requestCookies != null) {
                http.setRequestHeader("Cookie", this.requestCookies.toString().replaceAll("\"", ""));
            }
        }
    }

    private boolean isTxnIncompatible() {
        if (this.compatibleTxnMode) {
            return false;
        }
        if (this.serverVersion == null) {
            return false;
        }
        String[] vers = this.serverVersion.split("\\.");
        if (vers.length < 2) {
            return true;
        }
        int majorVer = Integer.parseInt(vers[0]);
        return majorVer < 8;
    }

    private Session.TransactionMode parseTransactionMode(String val) {
        if (val.equals("auto")) {
            return Session.TransactionMode.AUTO;
        }
        if (val.equals("query")) {
            return Session.TransactionMode.QUERY;
        }
        if (val.equals("update")) {
            return Session.TransactionMode.UPDATE;
        }
        if (val.equals("update-auto-commit")) {
            return Session.TransactionMode.UPDATE_AUTO_COMMIT;
        }
        if (val.equals("multi-auto")) {
            return Session.TransactionMode.MULTI_AUTO;
        }
        if (val.equals("query-single-statement")) {
            return Session.TransactionMode.QUERY_SINGLE_STATEMENT;
        }
        return Session.TransactionMode.AUTO;
    }

    public String getBasePath() {
        return this.basePath;
    }

    private void assertSessionOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Session has been closed");
        }
    }

    private void throwIllegalArg(String msg, Logger logger) {
        logger.severe(msg);
        throw new IllegalArgumentException(msg);
    }

    void throwIllegalState(String msg) {
        this.getLogger().severe(msg);
        throw new IllegalStateException(msg);
    }

    public String toString() {
        return this.credentials.toString() + ", cb=" + (this.contentBase == null ? "{default}" : this.contentBase) + " [ContentSource: " + this.contentSource.toString() + "]";
    }

    @Override
    public int getCachedTxnTimeout() {
        return this.timeout;
    }

    @Override
    public Session.Update getUpdate() {
        return this.txnMode.getUpdate();
    }

    @Override
    public void setUpdate(Session.Update update) {
        this.commitMode = true;
        if (this.txnMode == null) {
            switch (update) {
                case AUTO: {
                    this.txnMode = Session.TransactionMode.AUTO;
                    return;
                }
                case TRUE: {
                    this.txnMode = Session.TransactionMode.UPDATE_AUTO_COMMIT;
                    return;
                }
                case FALSE: {
                    this.txnMode = Session.TransactionMode.QUERY_SINGLE_STATEMENT;
                    return;
                }
            }
        }
        if (update == this.txnMode.getUpdate()) {
            return;
        }
        if (this.getTxnID() != null) {
            this.throwIllegalState("Cannot change transaction's update mode when there is an active transaction");
        }
        this.txnMode = this.txnMode.setUpdate(update);
    }
}

