/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.types.impl;

import com.marklogic.io.IOHelper;
import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.XdmBinary;
import com.marklogic.xcc.types.impl.AbstractItem;
import com.marklogic.xcc.types.impl.StreamableItem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class BinaryImpl
extends AbstractItem
implements XdmBinary,
StreamableItem {
    private InputStream stream;
    private byte[] bytes = null;

    public BinaryImpl(InputStream bodyStream, boolean cache) {
        super(ValueType.BINARY);
        this.stream = bodyStream;
        if (cache) {
            this.asBinaryData();
        }
    }

    @Override
    public boolean isFetchable() {
        return this.bytes != null || this.stream != null;
    }

    @Override
    public void invalidate() {
        this.bytes = null;
        if (this.stream != null) {
            try {
                this.stream.skip(Long.MAX_VALUE);
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.stream = null;
        }
    }

    @Override
    public boolean isCached() {
        return this.bytes != null;
    }

    @Override
    public Reader asReader() {
        return new InputStreamReader(this.asInputStream());
    }

    @Override
    public InputStream asInputStream() {
        if (this.bytes != null) {
            return new ByteArrayInputStream(this.bytes);
        }
        InputStream tmp = this.stream;
        this.stream = null;
        return tmp;
    }

    @Override
    public String asString() {
        try {
            return new String(this.asBinaryData(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.asBinaryData());
        }
    }

    @Override
    public byte[] asBinaryData() {
        if (this.bytes != null) {
            return (byte[])this.bytes.clone();
        }
        if (this.stream == null) {
            throw new IllegalStateException("stream data has already been consumed");
        }
        try {
            this.bytes = IOHelper.byteArrayFromStream(this.stream);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException buffering binary data", e);
        }
        this.stream = null;
        return (byte[])this.bytes.clone();
    }

    @Override
    public Node asW3cNode(DocumentBuilder docBuilder) throws IOException, SAXException {
        throw new UnsupportedOperationException("binary() cannot be converted to a W3C Node");
    }

    @Override
    public Node asW3cNode() throws ParserConfigurationException, IOException, SAXException {
        return this.asW3cNode(null);
    }
}

