/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl;

import com.marklogic.http.HttpChannel;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.UserCredentials;
import com.marklogic.xcc.impl.Credentials;
import com.marklogic.xcc.impl.MLCloudAuthManager;
import com.marklogic.xcc.impl.SessionImpl;
import com.marklogic.xcc.spi.ConnectionProvider;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class ContentSourceImpl
implements ContentSource {
    private static final String DEFAULT_LOGGER_NAME = "com.marklogic.xcc";
    private static final String XCC_LOGGING_CONFIG_FILE = "xcc.logging.properties";
    private static final String XCC_CONFIG_FILE = "xcc.properties";
    private static final String SYSTEM_LOGGING_CONFIG_CLASS = "java.util.logging.config.class";
    private static final String SYSTEM_LOGGING_CONFIG_FILE = "java.util.logging.config.file";
    private final ConnectionProvider connectionProvider;
    private final String contentBase;
    private final String basePath;
    private boolean authenticationPreemptive = false;
    private boolean challengeIgnored = false;
    private Logger logger = ContentSourceImpl.newDefaultLogger();
    private AuthType authType = AuthType.NONE;
    private String challenge;
    private Credentials credentials;
    private static MLCloudAuthManager mlCloudAuthManager;

    private static Logger newDefaultLogger() {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = logManager.getLogger(DEFAULT_LOGGER_NAME);
        if (logger != null) {
            return logger;
        }
        if (System.getProperty(SYSTEM_LOGGING_CONFIG_CLASS) != null || System.getProperty(SYSTEM_LOGGING_CONFIG_FILE) != null) {
            return Logger.getLogger(DEFAULT_LOGGER_NAME);
        }
        return ContentSourceImpl.customizedLogger(logManager);
    }

    private void initializeConfig() {
        URL url = this.getClass().getClassLoader().getResource(XCC_CONFIG_FILE);
        Properties props = System.getProperties();
        if (url != null) {
            try (FileInputStream is = new FileInputStream(url.getPath());){
                props.load(is);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "property file not found:" + url.getPath());
            }
        }
    }

    public ContentSourceImpl(ConnectionProvider connectionProvider, char[] OAuthToken, String contentBase, String basePath) {
        this(connectionProvider, new Credentials(OAuthToken), contentBase, basePath);
    }

    public ContentSourceImpl(ConnectionProvider connectionProvider, String user, char[] password, String contentBase) {
        this(connectionProvider, new Credentials(user, password), contentBase, null);
    }

    public ContentSourceImpl(ConnectionProvider connectionProvider, String user, char[] password, String contentBase, String basePath) {
        this(connectionProvider, new Credentials(user, password), contentBase, basePath);
    }

    public ContentSourceImpl(ConnectionProvider connectionProvider, char[] apiKey, String contentBase, String basePath, String tokenEndpoint, String grantType, int tokenDuration) {
        this(connectionProvider, new Credentials(apiKey, tokenEndpoint, grantType, tokenDuration), contentBase, basePath);
    }

    public ContentSourceImpl(ConnectionProvider connectionProvider, Credentials credentials, String contentBase, String basePath) {
        this.connectionProvider = connectionProvider;
        this.credentials = credentials;
        String cbName = contentBase;
        this.basePath = basePath;
        if (cbName != null && (cbName = cbName.trim()).length() == 0) {
            cbName = null;
        }
        this.contentBase = cbName;
        this.initializeConfig();
        this.initTokenBasedAuth();
    }

    private ContentSourceImpl(ConnectionProvider connectionProvider, Credentials credentials, String basePath) {
        this.connectionProvider = connectionProvider;
        this.credentials = credentials;
        this.basePath = basePath;
        this.contentBase = null;
    }

    private void initTokenBasedAuth() {
        if (this.credentials.getMLCloudAuthConfig() != null) {
            this.setMLCloudAuthType();
            HttpChannel.setUseHTTP(true);
            MLCloudAuthManager.createMLCloudAuthContext(new ContentSourceImpl(this.connectionProvider, this.credentials, this.basePath));
        } else if (this.credentials.getOAuthToken() != null) {
            this.setOAuthAuthType();
        }
    }

    @Override
    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public UserCredentials getUserCredentials() {
        return this.credentials;
    }

    @Override
    public Session newSession() {
        return new SessionImpl(this, this.connectionProvider, this.credentials, this.contentBase, this.basePath);
    }

    @Override
    public Session newSession(String userName, char[] password) {
        return new SessionImpl(this, this.connectionProvider, new Credentials(userName, password), this.contentBase, this.basePath);
    }

    @Override
    public Session newSession(String user, char[] password, String contentBaseArg) {
        String contentBase = contentBaseArg == null ? this.contentBase : contentBaseArg;
        return new SessionImpl(this, this.connectionProvider, new Credentials(user, password), contentBase, this.basePath);
    }

    @Override
    public Session newSession(String databaseId) {
        return new SessionImpl(this, this.connectionProvider, this.credentials, databaseId, this.basePath);
    }

    @Override
    public Logger getDefaultLogger() {
        return this.logger;
    }

    @Override
    public void setDefaultLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isAuthenticationPreemptive() {
        return this.authenticationPreemptive;
    }

    @Override
    public void setAuthenticationPreemptive(boolean value) {
        this.authenticationPreemptive = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthChallenge(String challenge) {
        ContentSourceImpl contentSourceImpl = this;
        synchronized (contentSourceImpl) {
            this.authType = AuthType.valueOf(challenge.split(" ")[0].toUpperCase());
            this.challenge = challenge;
        }
    }

    public synchronized void setMLCloudAuthType() {
        this.authType = AuthType.MLCLOUD;
    }

    public synchronized void setOAuthAuthType() {
        this.authType = AuthType.OAUTH;
    }

    public boolean isChallengeIgnored() {
        return this.challengeIgnored;
    }

    public void setChallengeIgnored(boolean challengeIgnored) {
        this.challengeIgnored = challengeIgnored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAuthString(String method, String uri, UserCredentials credentials) {
        String challenge;
        AuthType authType;
        ContentSourceImpl contentSourceImpl = this;
        synchronized (contentSourceImpl) {
            authType = this.authType;
            challenge = this.challenge;
        }
        switch (authType) {
            case BASIC: {
                return credentials.toHttpBasicAuth();
            }
            case DIGEST: {
                return credentials.toHttpDigestAuth(method, uri, challenge);
            }
            case NEGOTIATE: {
                return credentials.toHttpNegotiateAuth(this.connectionProvider.getHostName(), challenge);
            }
            case MLCLOUD: {
                return credentials.toMLCloudAuth();
            }
            case OAUTH: {
                return credentials.toOAuth();
            }
        }
        return this.isAuthenticationPreemptive() ? credentials.toHttpBasicAuth() : null;
    }

    public String toString() {
        return "user=" + (this.credentials.getUserName() == null ? "{none}" : this.credentials.getUserName()) + ", cb=" + (this.contentBase == null ? "{none}" : this.contentBase) + " [provider: " + this.connectionProvider.toString() + "]";
    }

    private static Logger customizedLogger(LogManager logManager) {
        Properties props = ContentSourceImpl.loadLoggingPropertiesFromResource();
        Logger logger = Logger.getLogger(DEFAULT_LOGGER_NAME);
        List<Handler> handlers = ContentSourceImpl.getLoggerHandlers(logger, logManager, props);
        Iterator<Handler> it = handlers.iterator();
        while (it.hasNext()) {
            logger.addHandler(it.next());
        }
        boolean useParentHandlers = ContentSourceImpl.getUseParentHandlersFlag(logger, logManager, props);
        logger.setUseParentHandlers(useParentHandlers);
        logManager.addLogger(logger);
        return logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadLoggingPropertiesFromResource() {
        Object logger;
        Properties props;
        block29: {
            props = new Properties();
            URL url = ClassLoader.getSystemResource(XCC_LOGGING_CONFIG_FILE);
            if (url != null) {
                try (FileInputStream is = new FileInputStream(url.getPath());){
                    props.load(is);
                    Properties throwable3 = props;
                    return throwable3;
                }
                catch (IOException e) {
                    logger = Logger.getLogger(DEFAULT_LOGGER_NAME);
                    if (logger == null) break block29;
                    ((Logger)logger).warning("property file not found: " + url);
                }
            }
        }
        try {
            InputStream is = ContentSource.class.getResourceAsStream(XCC_LOGGING_CONFIG_FILE);
            logger = null;
            try {
                if (is == null) return props;
                props.load(is);
                return props;
            }
            catch (Throwable throwable) {
                logger = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (logger != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)logger).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            logger = Logger.getLogger(DEFAULT_LOGGER_NAME);
            if (logger == null) return props;
            ((Logger)logger).warning("Error loading default logging file: " + e.getMessage());
        }
        return props;
    }

    private static List<Handler> getLoggerHandlers(Logger logger, LogManager logManager, Properties props) {
        String propName = logger.getName() + ".handlers";
        String handlerPropVal = ContentSourceImpl.getPropertyValue(propName, logManager, props);
        if (handlerPropVal == null) {
            return new ArrayList<Handler>(0);
        }
        String[] handlerClassNames = handlerPropVal.split("\\\\s*,?\\\\s*");
        ArrayList<Handler> handlers = new ArrayList<Handler>(handlerClassNames.length);
        Level level = ContentSourceImpl.getLoggerLevel(logger, logManager, props);
        if (level != null) {
            logger.setLevel(level);
        }
        for (int i = 0; i < handlerClassNames.length; ++i) {
            try {
                Class<Handler> handlerClass = Class.forName(handlerClassNames[i]).asSubclass(Handler.class);
                Handler handler = handlerClass.newInstance();
                Formatter formatter = ContentSourceImpl.getFormatter(handler, logManager, props);
                handlers.add(handler);
                if (formatter != null) {
                    handler.setFormatter(formatter);
                }
                if (level == null) continue;
                handler.setLevel(level);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return handlers;
    }

    private static Formatter getFormatter(Handler handler, LogManager logManager, Properties props) {
        String propName = handler.getClass().getName() + ".formatter";
        String formatterClassName = ContentSourceImpl.getPropertyValue(propName, logManager, props);
        try {
            Class<Formatter> clazz = Class.forName(formatterClassName).asSubclass(Formatter.class);
            Constructor<Formatter> cons = null;
            try {
                cons = clazz.getConstructor(Properties.class, LogManager.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cons != null) {
                return cons.newInstance(props, logManager);
            }
            return (Formatter)Class.forName(formatterClassName).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Level getLoggerLevel(Logger logger, LogManager logManager, Properties props) {
        String propName = logger.getName() + ".level";
        String levelName = ContentSourceImpl.getPropertyValue(propName, logManager, props);
        try {
            return Level.parse(levelName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean getUseParentHandlersFlag(Logger logger, LogManager logManager, Properties props) {
        String propName = logger.getName() + ".useParentHandlers";
        String propValue = ContentSourceImpl.getPropertyValue(propName, logManager, props);
        if (propValue == null) {
            return false;
        }
        try {
            return Boolean.valueOf(propValue);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String getPropertyValue(String propName, LogManager logManager, Properties props) {
        String propVal = props.getProperty(propName);
        if (propVal != null) {
            return propVal.trim();
        }
        propVal = logManager.getProperty(propName);
        if (propVal != null) {
            return propVal.trim();
        }
        return null;
    }

    @Override
    public Session newSession(String userName, String password) {
        return this.newSession(userName, password == null ? null : password.toCharArray());
    }

    @Override
    public Session newSession(String userName, String password, String contentbaseId) {
        return this.newSession(userName, password == null ? null : password.toCharArray(), contentbaseId);
    }

    public static enum AuthType {
        NONE,
        BASIC,
        DIGEST,
        NEGOTIATE,
        MLCLOUD,
        OAUTH;

    }
}

