/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc;

import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.SecurityOptions;
import com.marklogic.xcc.exceptions.XccConfigException;
import com.marklogic.xcc.impl.ContentSourceImpl;
import com.marklogic.xcc.impl.Credentials;
import com.marklogic.xcc.impl.SSLSocketPoolProvider;
import com.marklogic.xcc.impl.SocketPoolProvider;
import com.marklogic.xcc.spi.ConnectionProvider;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ContentSourceFactory {
    static final long GC_INTERVAL = Integer.parseInt(System.getProperty("xcc.gcinterval", "10000"));
    private static final String[] knownSchemes = new String[]{"xcc", "xccs", "xdbc"};
    private static final String[] secureSchemes = new String[]{"xccs"};
    private static final int STANDARD_PROVIDER_CACHE_SIZE = Integer.getInteger("xcc.connectionprovider.standard.cache.size", 8);
    private static final int SECURE_PROVIDER_CACHE_SIZE = Integer.getInteger("xcc.connectionprovider.secure.cache.size", 8);
    private static final Map<Object, ConnectionProvider> standardProviders = new ConcurrentHashMap<Object, ConnectionProvider>(STANDARD_PROVIDER_CACHE_SIZE);
    private static final Map<Object, ConnectionProvider> secureProviders = new ConcurrentHashMap<Object, ConnectionProvider>(SECURE_PROVIDER_CACHE_SIZE);
    private static final ConnectionCollector gc = new ConnectionCollector();

    private ContentSourceFactory() {
    }

    private static Credentials getTokenBasedAuthCredentials(char[] authStr, String authType) {
        ContentSourceImpl.AuthType type = ContentSourceImpl.AuthType.valueOf(authType.toUpperCase());
        switch (type) {
            case MLCLOUD: {
                return new Credentials(authStr, null, null, 0);
            }
            case OAUTH: {
                return new Credentials(authStr);
            }
        }
        return new Credentials();
    }

    public static ContentSource newContentSource(ConnectionProvider connectionProvider, char[] authStr, String authType, String contentbaseName, String basePath) {
        return new ContentSourceImpl(connectionProvider, ContentSourceFactory.getTokenBasedAuthCredentials(authStr, authType), contentbaseName, basePath);
    }

    public static ContentSource newContentSource(String host, int port, char[] authStr, String authType, String contentbaseName, String basePath, SecurityOptions options) {
        return ContentSourceFactory.newContentSource(options == null ? ContentSourceFactory.defaultConnectionProvider(host, port) : ContentSourceFactory.defaultSecureConnectionProvider(host, port, options), authStr, authType, contentbaseName, basePath);
    }

    public static ContentSource newContentSource(String host, int port, char[] authStr, String authType, String contentbaseName, String basePath) {
        return ContentSourceFactory.newContentSource(host, port, authStr, authType, contentbaseName, basePath, null);
    }

    public static ContentSource newContentSource(String host, int port, char[] authStr, String authType, String contentbaseName) {
        return ContentSourceFactory.newContentSource(host, port, authStr, authType, contentbaseName, null, null);
    }

    public static ContentSource newContentSource(String host, int port, char[] authStr, String authType) {
        return ContentSourceFactory.newContentSource(host, port, authStr, authType, null, null, null);
    }

    public static ContentSource newContentSource(ConnectionProvider connectionProvider, String user, char[] password, String contentbaseName, String basePath) {
        return new ContentSourceImpl(connectionProvider, user, password, contentbaseName, basePath);
    }

    public static ContentSource newContentSource(String host, int port, String user, char[] password, String contentbaseName, String basePath, SecurityOptions options) {
        return ContentSourceFactory.newContentSource(options == null ? ContentSourceFactory.defaultConnectionProvider(host, port) : ContentSourceFactory.defaultSecureConnectionProvider(host, port, options), user, password, contentbaseName, basePath);
    }

    public static ContentSource newContentSource(String host, int port, String user, char[] password, String contentbaseName, String basePath) {
        return ContentSourceFactory.newContentSource(host, port, user, password, contentbaseName, basePath, null);
    }

    private static ContentSource newContentSource(ConnectionProvider connectionProvider, char[] apiKey, String contentbaseName, String basePath, String tokenEndpoint, String grantType, int tokenDuration) {
        return new ContentSourceImpl(connectionProvider, apiKey, contentbaseName, basePath, tokenEndpoint, grantType, tokenDuration);
    }

    public static ContentSource newContentSource(ConnectionProvider connectionProvider, char[] apiKey, String contentbaseName, String basePath) {
        return ContentSourceFactory.newContentSource(connectionProvider, apiKey, contentbaseName, basePath, null, null, 0);
    }

    private static ContentSource newContentSource(String host, int port, char[] apiKey, String contentbaseName, String basePath, String tokenEndpoint, String grantType, int tokenDuration, SecurityOptions options) {
        return ContentSourceFactory.newContentSource(options == null ? ContentSourceFactory.defaultConnectionProvider(host, port) : ContentSourceFactory.defaultSecureConnectionProvider(host, port, options), apiKey, contentbaseName, basePath, tokenEndpoint, grantType, tokenDuration);
    }

    public static ContentSource newContentSource(String host, int port, char[] apiKey, String contentbaseName, String basePath, SecurityOptions options) {
        return ContentSourceFactory.newContentSource(host, port, apiKey, contentbaseName, basePath, null, null, 0, options);
    }

    public static ContentSource newContentSource(String host, int port, Credentials credentials, String contentbaseName, String basePath) {
        return ContentSourceFactory.newContentSource(host, port, credentials, contentbaseName, basePath, null);
    }

    public static ContentSource newContentSource(String host, int port, Credentials credentials, String contentbaseName, String basePath, SecurityOptions options) {
        return new ContentSourceImpl(options == null ? ContentSourceFactory.defaultConnectionProvider(host, port) : ContentSourceFactory.defaultSecureConnectionProvider(host, port, options), credentials, contentbaseName, basePath);
    }

    @Deprecated
    public static ContentSource newContentSource(ConnectionProvider connectionProvider, String user, String password, String contentbaseName) {
        return new ContentSourceImpl(connectionProvider, user, password == null ? null : password.toCharArray(), contentbaseName);
    }

    public static ContentSource newContentSource(ConnectionProvider connectionProvider, String user, char[] password, String contentbaseName) {
        return new ContentSourceImpl(connectionProvider, user, password, contentbaseName);
    }

    public static ContentSource newContentSource(URI uri, SecurityOptions options) throws XccConfigException {
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        String userInfoStr = uri.getUserInfo();
        String contentBase = uri.getPath();
        String query = uri.getQuery();
        if (!ContentSourceFactory.validScheme(scheme)) {
            throw new XccConfigException("Unrecognized connection scheme: " + scheme);
        }
        if (!ContentSourceFactory.secureScheme(scheme) && options != null) {
            throw new XccConfigException("Non-Secure connection requested but SecurityOptions is non-null");
        }
        if (contentBase != null) {
            if (contentBase.startsWith("/")) {
                contentBase = contentBase.substring(1);
            }
            if (contentBase.length() == 0 && (contentBase = uri.getFragment()) != null) {
                contentBase = "#" + contentBase;
            }
        }
        return ContentSourceFactory.buildContentSourceFromURI(query, userInfoStr, host, port, contentBase, options);
    }

    public static ContentSource newContentSource(URI uri) throws XccConfigException {
        return ContentSourceFactory.newContentSource(uri, null);
    }

    @Deprecated
    public static ContentSource newContentSource(String host, int port, String user, String password, String contentbaseName, SecurityOptions options) {
        return ContentSourceFactory.newContentSource(options == null ? ContentSourceFactory.defaultConnectionProvider(host, port) : ContentSourceFactory.defaultSecureConnectionProvider(host, port, options), user, password, contentbaseName);
    }

    public static ContentSource newContentSource(String host, int port, String user, char[] password, String contentbaseName, SecurityOptions options) {
        return ContentSourceFactory.newContentSource(options == null ? ContentSourceFactory.defaultConnectionProvider(host, port) : ContentSourceFactory.defaultSecureConnectionProvider(host, port, options), user, password, contentbaseName);
    }

    @Deprecated
    public static ContentSource newContentSource(String host, int port, String user, String password, String contentbaseName) {
        return ContentSourceFactory.newContentSource(host, port, user, password, contentbaseName, null);
    }

    public static ContentSource newContentSource(String host, int port, String user, char[] password, String contentbaseName) {
        return ContentSourceFactory.newContentSource(host, port, user, password, contentbaseName, null, null);
    }

    @Deprecated
    public static ContentSource newContentSource(String host, int port, String user, String password) {
        return ContentSourceFactory.newContentSource(host, port, user, password, null);
    }

    public static ContentSource newContentSource(String host, int port, String user, char[] password) {
        return ContentSourceFactory.newContentSource(host, port, user, password, null);
    }

    public static ContentSource newContentSource(String host, int port) {
        return ContentSourceFactory.newContentSource(host, port, null, (char[])null, null);
    }

    static ConnectionProvider defaultConnectionProvider(String host, int port) {
        InetSocketAddress address = new InetSocketAddress(host, port);
        if (address.isUnresolved()) {
            throw new IllegalArgumentException("Default provider - Not a usable net address: " + address);
        }
        ConnectionProvider provider = standardProviders.get(address);
        if (provider == null) {
            provider = new SocketPoolProvider(address);
            standardProviders.put(address, provider);
        }
        gc.checkAlive();
        return provider;
    }

    private static ConnectionProvider defaultSecureConnectionProvider(String host, int port, SecurityOptions options) {
        final InetSocketAddress address = new InetSocketAddress(host, port);
        if (address.isUnresolved()) {
            throw new IllegalArgumentException("Default secure provider - Not a usable net address: " + address);
        }
        final SecurityOptions securityOptions = new SecurityOptions(options);
        class Key {
            Key() {
            }

            public InetSocketAddress getAddress() {
                return address;
            }

            public SecurityOptions getSecurityOptions() {
                return securityOptions;
            }

            public int hashCode() {
                return address.hashCode() + securityOptions.hashCode();
            }

            public boolean equals(Object o) {
                if (o instanceof Key) {
                    Key k = (Key)o;
                    return this == k || address.equals(k.getAddress()) && securityOptions.equals(k.getSecurityOptions());
                }
                return false;
            }
        }
        Key key = new Key();
        ConnectionProvider provider = secureProviders.get(key);
        if (provider == null) {
            try {
                provider = new SSLSocketPoolProvider(address, securityOptions);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            secureProviders.put(key, provider);
        }
        gc.checkAlive();
        return provider;
    }

    private static boolean validScheme(String scheme) {
        if (scheme == null) {
            return false;
        }
        for (int i = 0; i < knownSchemes.length; ++i) {
            if (!scheme.equalsIgnoreCase(knownSchemes[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean secureScheme(String scheme) {
        if (scheme == null) {
            return false;
        }
        for (int i = 0; i < secureSchemes.length; ++i) {
            if (!scheme.equalsIgnoreCase(secureSchemes[i])) continue;
            return true;
        }
        return false;
    }

    private static ContentSource buildContentSourceFromURI(String query, String userInfoStr, String host, int port, String contentBase, SecurityOptions options) throws XccConfigException {
        Credentials credentials;
        char[] OAuthToken;
        String tokenDuration;
        String basePath;
        LinkedHashMap<String, String> queryPairs = new LinkedHashMap<String, String>();
        if (query != null) {
            try {
                String[] pairs;
                for (String pair : pairs = query.split("&")) {
                    int i = pair.indexOf("=");
                    queryPairs.put(URLDecoder.decode(pair.substring(0, i), "UTF-8"), URLDecoder.decode(pair.substring(i + 1), "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new XccConfigException("Unsupported encoding in xcc URI.", e);
            }
        }
        String[] userInfo = userInfoStr != null ? userInfoStr.split(":", 2) : new String[]{};
        String string = basePath = queryPairs.isEmpty() ? null : (String)queryPairs.get("basepath");
        char[] apiKey = queryPairs.isEmpty() ? null : (queryPairs.get("apikey") == null ? null : ((String)queryPairs.get("apikey")).toCharArray());
        String tokenEndpoint = queryPairs.isEmpty() ? null : (String)queryPairs.get("tokenendpoint");
        String grantType = queryPairs.isEmpty() ? null : (String)queryPairs.get("granttype");
        String string2 = tokenDuration = queryPairs.isEmpty() ? null : (String)queryPairs.get("tokenduration");
        char[] cArray = queryPairs.isEmpty() ? null : (OAuthToken = queryPairs.get("oauthtoken") == null ? null : ((String)queryPairs.get("oauthtoken")).toCharArray());
        if (apiKey != null) {
            if (basePath == null) {
                throw new XccConfigException("Base path cannot be empty.");
            }
            credentials = new Credentials(apiKey, tokenEndpoint, grantType, tokenDuration == null ? 0 : Integer.parseInt(tokenDuration));
        } else {
            credentials = OAuthToken != null ? new Credentials(OAuthToken) : (userInfo.length != 2 || userInfo[0].length() == 0 || userInfo[1].length() == 0 ? new Credentials(null, null) : new Credentials(userInfo[0], userInfo[1].toCharArray()));
        }
        return ContentSourceFactory.newContentSource(host, port, credentials, contentBase, basePath, options);
    }

    static class ConnectionCollector
    extends Thread {
        ConnectionCollector() {
        }

        @Override
        public void run() {
            block2: while (true) {
                try {
                    Thread.sleep(GC_INTERVAL);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long currTime = System.currentTimeMillis();
                for (ConnectionProvider pool : standardProviders.values()) {
                    pool.closeExpired(currTime);
                }
                Iterator iterator = secureProviders.values().iterator();
                while (true) {
                    ConnectionProvider pool;
                    if (!iterator.hasNext()) continue block2;
                    pool = (ConnectionProvider)iterator.next();
                    pool.closeExpired(currTime);
                }
                break;
            }
        }

        public synchronized void checkAlive() {
            if (!this.isAlive()) {
                this.setDaemon(true);
                try {
                    this.setPriority(1);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                this.start();
            }
        }
    }
}

