/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.types.impl;

import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.XSDouble;
import com.marklogic.xcc.types.impl.AbstractStringItem;
import java.math.BigDecimal;
import java.math.BigInteger;

public class XsDoubleImpl
extends AbstractStringItem
implements XSDouble {
    private final Double value;
    private final BigDecimal bigDecimalValue;
    private final NumberFormatException formatException;

    public XsDoubleImpl(String bodyString) {
        super(ValueType.XS_DOUBLE, bodyString);
        this.value = Double.valueOf(this.scrubbedFloatValue(bodyString));
        BigDecimal tmpBigDecimal = null;
        NumberFormatException tmpEx = null;
        try {
            tmpBigDecimal = new BigDecimal(bodyString);
        }
        catch (NumberFormatException e) {
            tmpEx = e;
        }
        this.bigDecimalValue = tmpBigDecimal;
        this.formatException = tmpEx;
    }

    public XsDoubleImpl(Object value) {
        super(ValueType.XS_DOUBLE, value.toString());
        NumberFormatException tmpEx;
        BigDecimal tmpBigDecimal;
        if (value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Float || value instanceof BigDecimal || value instanceof BigInteger || value instanceof String) {
            this.value = new Double(value.toString());
            tmpBigDecimal = null;
            tmpEx = null;
            try {
                tmpBigDecimal = new BigDecimal(value.toString());
            }
            catch (NumberFormatException e) {
                tmpEx = e;
            }
        } else {
            throw new IllegalArgumentException("Cannot construct XSDouble from " + value.getClass().getName());
        }
        this.bigDecimalValue = tmpBigDecimal;
        this.formatException = tmpEx;
    }

    @Override
    public Double asDouble() {
        return this.value;
    }

    @Override
    public double asPrimitiveDouble() {
        return this.value;
    }

    @Override
    public BigDecimal asBigDecimal() {
        if (this.bigDecimalValue == null) {
            throw this.formatException;
        }
        return this.bigDecimalValue;
    }
}

