/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl.handlers;

import com.marklogic.http.HttpChannel;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.exceptions.MLCloudRequestException;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.ServerConnectionException;
import com.marklogic.xcc.impl.handlers.ResponseHandler;
import java.io.IOException;
import java.util.logging.Logger;

public class ServiceUnavailableHandler
implements ResponseHandler {
    @Override
    public Object handleResponse(HttpChannel http, int responseCode, Request request, Object attachment, Logger logger) throws RequestException {
        String responseMessage = null;
        try {
            responseMessage = http.getResponseMessage();
        }
        catch (IOException e) {
            responseMessage = "(no message returned by server)";
        }
        if (request.getSession().getUserCredentials().getMLCloudAuthConfig() != null) {
            throw new MLCloudRequestException("(" + responseCode + ", " + responseMessage + "). MarkLogic Cloud cannot accept request.", request, true);
        }
        throw new ServerConnectionException("Server cannot accept request: " + responseMessage, request);
    }
}

