/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl.handlers;

import com.marklogic.http.BMBoundaryPartSplitter;
import com.marklogic.http.HttpChannel;
import com.marklogic.http.MultipartBuffer;
import com.marklogic.http.MultipartSplitter;
import com.marklogic.http.NullPartSplitter;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.impl.CachedResultSequence;
import com.marklogic.xcc.impl.StreamingResultSequence;
import com.marklogic.xcc.impl.handlers.ResponseHandler;
import com.marklogic.xcc.spi.ServerConnection;
import java.io.IOException;
import java.util.logging.Logger;

public class GoodQueryResponseHandler
implements ResponseHandler {
    @Override
    public Object handleResponse(HttpChannel http, int responseCode, Request request, Object attachment, Logger logger) throws RequestException, IOException {
        RequestOptions options = request.getEffectiveOptions();
        String boundary = http.getResponseContentBoundary();
        MultipartSplitter splitter = boundary == null ? new NullPartSplitter() : new BMBoundaryPartSplitter(http.getResponseStream(), boundary.getBytes(), options.getResultBufferSize(), logger);
        MultipartBuffer mbuf = new MultipartBuffer(splitter);
        if (options.getCacheResult()) {
            logger.fine("ResultSequence is to be cached, reading");
            return new CachedResultSequence(request, mbuf, options);
        }
        logger.fine("ResultSequence is streaming");
        return new StreamingResultSequence(request, (ServerConnection)attachment, mbuf, options, logger);
    }
}

