/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl;

import com.marklogic.http.MultipartBuffer;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultChannelName;
import com.marklogic.xcc.ResultItem;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.impl.AbstractResultSequence;
import com.marklogic.xcc.impl.EmptyResultSequence;
import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.XdmItem;
import com.marklogic.xcc.types.impl.SequenceImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class CachedResultSequence
extends AbstractResultSequence {
    private final ArrayList<ResultItem> items = new ArrayList();
    private boolean closed = false;
    private int cursor = -1;
    private final ResultSequence primary;
    private long totalBytesRead;

    protected CachedResultSequence(ResultSequence primary) {
        super(((AbstractResultSequence)primary).getRequest());
        this.primary = primary;
    }

    public CachedResultSequence(Request request, MultipartBuffer multipartBuffer, RequestOptions options) throws RequestException, IOException {
        super(request);
        this.primary = this;
        int index = 0;
        while (this.sequencePart != null || multipartBuffer.hasNext()) {
            ResultItem item = this.instantiateResultItem(multipartBuffer, index, options);
            item.cache();
            this.items.add(item);
            ++index;
        }
        this.totalBytesRead = multipartBuffer.getTotalBytesRead();
    }

    @Override
    public long getTotalBytesRead() {
        return this.totalBytesRead;
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isCached() {
        return !this.closed;
    }

    @Override
    public void close() {
        this.items.clear();
        this.cursor = -1;
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        if (this.size() == 0) {
            return false;
        }
        return this.cursor + 1 < this.size();
    }

    @Override
    public ResultItem next() {
        this.assertNotClosed();
        if (this.cursor >= this.size() - 1) {
            this.cursor = this.size();
            return null;
        }
        ++this.cursor;
        return this.items.get(this.cursor);
    }

    @Override
    public ResultItem current() {
        this.assertNotClosed();
        if (this.cursor == -1 || this.cursor == this.size()) {
            throw new IllegalStateException("Cursor is not valid");
        }
        return this.items.get(this.cursor);
    }

    @Override
    public ResultItem resultItemAt(int index) {
        this.assertNotClosed();
        if (index < 0 || index >= this.size()) {
            throw new IllegalArgumentException("Index out of range: size=" + this.size() + ", requested=" + index);
        }
        return this.items.get(index);
    }

    @Override
    public void rewind() {
        this.assertNotClosed();
        this.cursor = -1;
    }

    @Override
    public Iterator<ResultItem> iterator() {
        this.assertNotClosed();
        return Collections.unmodifiableList(this.items).iterator();
    }

    @Override
    public ResultSequence toCached() {
        this.assertNotClosed();
        return this;
    }

    @Override
    public ResultSequence getChannel(ResultChannelName channel) {
        this.assertNotClosed();
        if (channel == ResultChannelName.PRIMARY) {
            return this.primary;
        }
        return new EmptyResultSequence(this);
    }

    @Override
    public boolean isEmpty() {
        return this.items.size() == 0;
    }

    @Override
    public ResultItem[] toResultItemArray() {
        this.assertNotClosed();
        ResultItem[] array = new ResultItem[this.size()];
        this.items.toArray(array);
        return array;
    }

    @Override
    public XdmItem[] toArray() {
        ResultItem[] resultItems = this.toResultItemArray();
        XdmItem[] array = new XdmItem[resultItems.length];
        for (int i = 0; i < resultItems.length; ++i) {
            array[i] = resultItems[i].getItem();
        }
        return array;
    }

    @Override
    public XdmItem itemAt(int index) {
        return this.resultItemAt(index).getItem();
    }

    @Override
    public ValueType getValueType() {
        return ValueType.SEQUENCE;
    }

    @Override
    public String asString(String separator) {
        return SequenceImpl.asStringConcatenation(this, separator);
    }

    @Override
    public String asString() {
        return this.asString("\n");
    }

    @Override
    public String[] asStrings() {
        return SequenceImpl.asStringArray(this);
    }

    @Override
    public String toString() {
        return "CachedResultSequence: size=" + this.size() + ", closed=" + this.isClosed() + ", cursor=" + this.cursor;
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("ResultSequence is closed");
        }
    }
}

