/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc;

import java.util.Arrays;
import javax.net.ssl.SSLContext;

public class SecurityOptions {
    private final SSLContext sslContext;
    private String[] enabledProtocols = null;
    private String[] enabledCipherSuites = null;

    public SecurityOptions(SSLContext context) {
        this.sslContext = context;
    }

    public SecurityOptions(SecurityOptions prototype) {
        this.sslContext = prototype.sslContext;
        this.setEnabledProtocols(prototype.enabledProtocols);
        this.setEnabledCipherSuites(prototype.enabledCipherSuites);
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols != null ? (String[])this.enabledProtocols.clone() : null;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        if (enabledProtocols == null) {
            this.enabledProtocols = null;
        } else {
            enabledProtocols = (String[])enabledProtocols.clone();
            Arrays.sort(enabledProtocols);
            this.enabledProtocols = enabledProtocols;
        }
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites != null ? (String[])this.enabledCipherSuites.clone() : null;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        if (enabledCipherSuites == null) {
            this.enabledCipherSuites = null;
        } else {
            enabledCipherSuites = (String[])enabledCipherSuites.clone();
            Arrays.sort(enabledCipherSuites);
            this.enabledCipherSuites = enabledCipherSuites;
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.enabledCipherSuites) + Arrays.hashCode(this.enabledProtocols) + (this.sslContext != null ? this.sslContext.hashCode() : 0);
    }

    public boolean equals(Object o) {
        if (o instanceof SecurityOptions) {
            if (this == o) {
                return true;
            }
            SecurityOptions so = (SecurityOptions)o;
            return this.sslContext == so.sslContext && Arrays.equals(this.enabledCipherSuites, so.enabledCipherSuites) && Arrays.equals(this.enabledProtocols, so.enabledProtocols);
        }
        return false;
    }
}

