/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.io;

import com.marklogic.xcc.spi.ServerConnection;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourcePool<K, R> {
    static final Logger logger = Logger.getLogger(ResourcePool.class.getName());
    private ConcurrentHashMap<K, Queue<PoolItem<R>>> pools = new ConcurrentHashMap();

    public boolean isEmpty(K key) {
        Queue<PoolItem<R>> queue = this.findQueue(key);
        return queue == null || queue.isEmpty();
    }

    public void put(K key, R resource, long expireTimeMillis) {
        this.addItemToQueue(key, resource, expireTimeMillis);
    }

    public void put(K key, R obj) {
        this.put(key, obj, -1L);
    }

    public R get(K key) {
        return this.getItemFromQueue(key);
    }

    public long size(K key) {
        Queue<PoolItem<R>> queue = this.findQueue(key);
        return queue == null ? 0 : queue.size();
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    private R getItemFromQueue(K key) {
        Queue<PoolItem<R>> queue = this.findQueue(key);
        if (queue == null) {
            return null;
        }
        long now = this.getCurrentTime();
        PoolItem<R> item = null;
        while (true) {
            if ((item = queue.poll()) == null) {
                return null;
            }
            if (!item.hasExpired(now)) break;
            item.close();
        }
        return item.getValue();
    }

    private void addItemToQueue(K key, R resource, long expireTimeMillis) {
        PoolItem<R> item = new PoolItem<R>(resource, expireTimeMillis);
        Queue<PoolItem<R>> queue = this.findOrCreateQueue(key);
        if (!item.hasExpired(this.getCurrentTime())) {
            queue.add(item);
        } else {
            item.close();
        }
    }

    private Queue<PoolItem<R>> findQueue(Object key) {
        return this.pools.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Queue<PoolItem<R>> findOrCreateQueue(K key) {
        Queue<PoolItem<R>> queue = this.findQueue(key);
        if (queue == null) {
            ConcurrentHashMap<K, Queue<PoolItem<R>>> concurrentHashMap = this.pools;
            synchronized (concurrentHashMap) {
                queue = new ConcurrentLinkedQueue<PoolItem<R>>();
                this.pools.put(key, queue);
            }
        }
        return queue;
    }

    public void closeExpired(long currTime) {
        int count = 0;
        for (Queue<PoolItem<R>> pool : this.pools.values()) {
            for (PoolItem poolItem : pool) {
                if (!poolItem.hasExpired(currTime)) continue;
                poolItem.close();
                pool.remove(poolItem);
                ++count;
            }
        }
        if (count > 0 && logger.isLoggable(Level.FINE)) {
            logger.fine("Closed " + count + " expired items.");
        }
    }

    protected static class PoolItem<R> {
        private R item;
        private long expireTime;

        public PoolItem(R item, long expireTime) {
            this.item = item;
            this.expireTime = expireTime;
        }

        public R getValue() {
            return this.item;
        }

        public boolean hasExpired(long currTime) {
            return this.expireTime != -1L && currTime >= this.expireTime;
        }

        public void close() {
            try {
                if (this.item instanceof SocketChannel) {
                    ((SocketChannel)this.item).close();
                } else if (this.item instanceof ServerConnection) {
                    ((ServerConnection)this.item).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

