/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.http;

public class BoyerMoore {
    public static final int ALPHABET_SIZE = 256;
    private byte[] pattern;
    private int[] jump;
    private int partialMatch;

    public int search(byte[] text, int start, int end) {
        this.partialMatch = 0;
        int i = start;
        int j = 0;
        int m = this.pattern.length;
        while (i < end) {
            for (j = m - 1; j >= 0 && (i + j >= end || text[i + j] == this.pattern[j]); --j) {
            }
            if (j < 0) {
                if (i + m - 1 >= end) {
                    this.partialMatch = end - i;
                    return -1;
                }
                this.partialMatch = 0;
                return i;
            }
            if (i + m - 1 < end) {
                int jumpDistance = j - this.jump[text[i + j] & 0xFF];
                if (jumpDistance <= 0) {
                    ++i;
                    continue;
                }
                i += jumpDistance;
                continue;
            }
            ++i;
        }
        return -1;
    }

    public int partialMatch() {
        return this.partialMatch;
    }

    private void initialize() {
        this.jump = new int[256];
        for (int k = 0; k < this.jump.length; ++k) {
            this.jump[k] = -1;
        }
        for (int j = this.pattern.length - 1; j >= 0; --j) {
            if (this.jump[this.pattern[j] & 0xFF] >= 0) continue;
            this.jump[this.pattern[j] & 0xFF] = j;
        }
    }

    public BoyerMoore(byte[] pattern) {
        this.pattern = pattern;
        this.initialize();
    }
}

