/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.utilities;

import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.utilities.AssignmentPolicy;
import com.marklogic.mapreduce.utilities.LegacyAssignmentPolicy;
import java.math.BigInteger;
import java.util.LinkedHashSet;

public class BucketAssignmentPolicy
extends AssignmentPolicy {
    static final int NUM_BUCKET = 16384;
    private int[][] buckets;
    private String[] forests;

    public BucketAssignmentPolicy(String[] forests, LinkedHashSet<String> uForests) {
        this.buckets = new int[forests.length][16384];
        this.initBucketsTable(forests.length);
        this.forests = forests;
        this.uForests = uForests;
        this.policy = AssignmentPolicy.Kind.BUCKET;
    }

    public int[][] getBucketsTable() {
        return this.buckets;
    }

    private void initBucketsTable(int maxSize) {
        for (int i = 1; i < maxSize; ++i) {
            int[] assignment = new int[16384];
            int[] expectCount = new int[maxSize];
            int[] currentCount = new int[maxSize];
            for (int j = 0; j < 16384; ++j) {
                assignment[j] = 0;
            }
            for (int forestCount = 2; forestCount <= maxSize; ++forestCount) {
                int minAmount = 16384 / forestCount;
                int remainAmount = 16384 - minAmount * forestCount;
                for (int k = 0; k < forestCount; ++k) {
                    expectCount[k] = minAmount;
                    if (remainAmount > 0) {
                        int n = k;
                        expectCount[n] = expectCount[n] + 1;
                        --remainAmount;
                    }
                    currentCount[k] = 0;
                }
                int newForest = forestCount - 1;
                for (int j = 0; j < 16384; ++j) {
                    int forest = assignment[j];
                    if (currentCount[forest] < expectCount[forest]) {
                        int n = forest;
                        currentCount[n] = currentCount[n] + 1;
                        continue;
                    }
                    assignment[j] = newForest;
                    int n = newForest;
                    currentCount[n] = currentCount[n] + 1;
                }
            }
            this.buckets[i] = assignment;
        }
    }

    @Override
    public int getPlacementForestIndex(DocumentURI uri) {
        return this.getBucketPlacementId(uri, this.buckets, 16384, this.forests.length, this.uForests.size());
    }

    private int getBucketPlacementId(DocumentURI uri, int[][] buckets, int numBuckets, int numForests, int uForests) {
        boolean allUpdatble;
        String nk = LegacyAssignmentPolicy.normalize(uri.getUri());
        BigInteger uriKey = LegacyAssignmentPolicy.getUriKey(nk);
        long u = uriKey.longValue();
        for (int i = 14; i <= 56; i += 14) {
            u ^= uriKey.shiftRight(i).longValue();
        }
        int bucket = (int)(u & 0x3FFFL);
        int fIdx = buckets[numForests - 1][bucket];
        boolean bl = allUpdatble = numForests == uForests;
        if (!allUpdatble) {
            int[] partv = new int[uForests];
            int j = 0;
            for (int i = 0; i < numForests; ++i) {
                if (!this.isUpdatable(i)) continue;
                partv[j++] = i;
            }
            fIdx = partv[LegacyAssignmentPolicy.getPlacementId(uri, uForests)];
        }
        return fIdx;
    }

    private boolean isUpdatable(int fIdx) {
        String forestId = this.forests[fIdx];
        return this.uForests.contains(forestId);
    }
}

