/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.MarkLogicNode;
import com.marklogic.mapreduce.MarkLogicOutputFormat;
import com.marklogic.mapreduce.NodePath;
import com.marklogic.mapreduce.NodeWriter;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.mapreduce.utilities.TextArrayWritable;
import com.marklogic.xcc.ContentSource;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class NodeOutputFormat
extends MarkLogicOutputFormat<NodePath, MarkLogicNode> {
    public static final Log LOG = LogFactory.getLog(NodeOutputFormat.class);

    public RecordWriter<NodePath, MarkLogicNode> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        TextArrayWritable hosts = this.getHosts(conf);
        String host = InternalUtilities.getHost(hosts);
        return new NodeWriter(conf, host);
    }

    @Override
    public void checkOutputSpecs(Configuration conf, ContentSource cs) throws IOException {
        if (conf.get("mapreduce.marklogic.output.batchsize") != null) {
            LOG.warn((Object)("Config entry for \"mapreduce.marklogic.output.batchsize\" is not supported for " + this.getClass().getName() + " and will be ignored."));
        }
        DefaultStringifier.store((Configuration)conf, (Object)((Object)this.queryHosts(cs)), (String)"mapreduce.marklogic.output.hostforests");
    }
}

