/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.MarkLogicConstants;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.XccConfigException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class MarkLogicRecordWriter<KEYOUT, VALUEOUT>
extends RecordWriter<KEYOUT, VALUEOUT>
implements MarkLogicConstants {
    public static final Log LOG = LogFactory.getLog(MarkLogicRecordWriter.class);
    private Session session;
    private int count = 0;
    protected Configuration conf;
    protected int txnSize;
    protected String hostName;

    public MarkLogicRecordWriter(Configuration conf, String hostName) {
        this.hostName = hostName;
        this.conf = conf;
        this.txnSize = this.getTransactionSize(conf);
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        if (this.session != null) {
            try {
                if (this.count > 0 && this.txnSize > 1) {
                    this.session.commit();
                }
                this.session.close();
            }
            catch (RequestException e) {
                LOG.error((Object)e);
            }
        }
    }

    protected Session getSession() throws IOException {
        if (this.session == null) {
            try {
                ContentSource cs = InternalUtilities.getOutputContentSource(this.conf, this.hostName);
                this.session = cs.newSession();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Connect to " + this.session.getConnectionUri().getHost()));
                }
                if (this.txnSize > 1) {
                    this.session.setTransactionMode(Session.TransactionMode.UPDATE);
                }
            }
            catch (XccConfigException e) {
                LOG.error((Object)"Error creating a new session: ", (Throwable)e);
                throw new IOException(e);
            }
        }
        return this.session;
    }

    protected void commitIfNecessary() throws RequestException {
        if (++this.count == this.txnSize && this.txnSize > 1) {
            this.session.commit();
            this.count = 0;
        }
    }

    public int getTransactionSize(Configuration conf) {
        return conf.getInt("mapreduce.marklogic.output.transactionsize", 1000);
    }
}

