/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.Indentation;
import com.marklogic.mapreduce.MarkLogicConstants;
import com.marklogic.mapreduce.MarkLogicCounter;
import com.marklogic.mapreduce.MarkLogicInputSplit;
import com.marklogic.mapreduce.functions.LexiconFunction;
import com.marklogic.mapreduce.utilities.ForestHost;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultItem;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.QueryException;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.XccConfigException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.ReflectionUtils;

public abstract class MarkLogicRecordReader<KEYIN, VALUEIN>
extends RecordReader<KEYIN, VALUEIN>
implements MarkLogicConstants {
    public static final Log LOG = LogFactory.getLog(MarkLogicRecordReader.class);
    protected MarkLogicInputSplit mlSplit;
    protected long count;
    protected Session session;
    protected ResultSequence result;
    protected Configuration conf;
    protected float length;
    protected String[] redactionRuleCol;
    protected List<ForestHost> replicas;
    protected int curForest;
    protected String[] hostNames;
    protected int retry;
    protected final int maxRetries = 15;
    protected int sleepTime;
    protected final int maxSleepTime = 30000;

    public MarkLogicRecordReader(Configuration conf) {
        this.conf = conf;
    }

    public void close() throws IOException {
        if (this.result != null) {
            this.result.close();
        }
        if (this.session != null) {
            this.session.close();
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public float getProgress() throws IOException, InterruptedException {
        return (float)this.count / this.length;
    }

    private void appendNamespace(Collection<String> nsCol, StringBuilder buf) {
        Iterator<String> nsIt = nsCol.iterator();
        while (nsIt.hasNext()) {
            String ns = nsIt.next();
            buf.append('\"').append(ns).append('\"');
            if (!nsIt.hasNext()) continue;
            buf.append(',');
        }
    }

    protected void buildSrcInDocExprQuery(String docExpr, String subExpr, StringBuilder buf) {
        buf.append("fn:unordered(fn:unordered(");
        buf.append(docExpr == null ? "fn:collection()" : docExpr);
        buf.append(")[$mlmr:splitstart to $mlmr:splitend]");
        buf.append(subExpr == null ? "" : subExpr);
        buf.append(")");
    }

    protected void buildDocExprQuery(String docExpr, Collection<String> nsCol, String subExpr, StringBuilder buf) {
        buf.append("xdmp:with-namespaces((");
        if (nsCol != null) {
            this.appendNamespace(nsCol, buf);
        }
        buf.append("),");
        if (this.redactionRuleCol != null) {
            buf.append("rdt:redact(");
            this.buildSrcInDocExprQuery(docExpr, subExpr, buf);
            buf.append(",((");
            for (int i = 0; i < this.redactionRuleCol.length; ++i) {
                if (i != 0) {
                    buf.append(",");
                }
                buf.append("\"" + this.redactionRuleCol[i] + "\"");
            }
            buf.append(")))");
        } else {
            this.buildSrcInDocExprQuery(docExpr, subExpr, buf);
        }
        buf.append(")");
    }

    protected void buildSrcInSearchQuery(String docExpr, String ctsQuery, StringBuilder buf) {
        ctsQuery = ctsQuery.replaceAll("&", "&amp;");
        ctsQuery = ctsQuery.replaceAll("'", "&apos;");
        buf.append("fn:unordered(cts:search(");
        buf.append(docExpr);
        buf.append(",cts:query(xdmp:unquote('");
        buf.append(ctsQuery);
        buf.append("')/*),(\"unfiltered\",\"score-zero\")))");
    }

    protected void buildSearchQuery(String docExpr, String ctsQuery, Collection<String> nsCol, StringBuilder buf) {
        if (docExpr == null) {
            docExpr = "fn:collection()";
        }
        buf.append("xdmp:with-namespaces((");
        if (nsCol != null) {
            this.appendNamespace(nsCol, buf);
        }
        buf.append("),");
        if (this.redactionRuleCol != null) {
            buf.append("rdt:redact(");
            this.buildSrcInSearchQuery(docExpr, ctsQuery, buf);
            buf.append(",((");
            for (int i = 0; i < this.redactionRuleCol.length; ++i) {
                if (i != 0) {
                    buf.append(",");
                }
                buf.append("\"" + this.redactionRuleCol[i] + "\"");
            }
            buf.append(")))");
        } else {
            this.buildSrcInSearchQuery(docExpr, ctsQuery, buf);
        }
        buf.append(")");
        buf.append("[$mlmr:splitstart to $mlmr:splitend]");
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        this.mlSplit = (MarkLogicInputSplit)split;
        this.count = 0L;
        context.getCounter((Enum)MarkLogicCounter.ESTIMATED_INPUT_RECORDS).increment(this.mlSplit.getLength());
        this.hostNames = this.mlSplit.getLocations();
        if (this.hostNames == null || this.hostNames.length < 1) {
            throw new IllegalStateException("Empty split locations.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("split location: " + this.hostNames[0]));
        }
        this.replicas = this.mlSplit.getReplicas();
        this.curForest = -1;
        if (this.replicas != null) {
            for (int i = 0; i < this.replicas.size(); ++i) {
                if (!this.replicas.get(i).getHostName().equals(this.hostNames[0])) continue;
                this.curForest = i;
                break;
            }
        }
        this.retry = 0;
        this.sleepTime = 500;
        this.init();
    }

    private void init() throws IOException, InterruptedException {
        long end;
        boolean advancedMode = this.conf.get("mapreduce.marklogic.input.mode", "basic").equals("advanced");
        this.redactionRuleCol = this.conf.getStrings("mapreduce.marklogic.input.redaction.rules");
        float recToFragRatio = this.conf.getFloat("mapreduce.marklogic.input.recordtofragmentratio", this.getDefaultRatio());
        this.length = (float)this.mlSplit.getLength() * recToFragRatio;
        String queryLanguage = null;
        String queryText = null;
        long start = this.mlSplit.getStart() + 1L + this.count;
        long l = end = this.mlSplit.isLastSplit() ? Long.MAX_VALUE : start + this.mlSplit.getLength() - this.count - 1L;
        if (!advancedMode) {
            Collection nsCol;
            StringBuilder buf = new StringBuilder();
            buf.append("xquery version \"1.0-ml\"; \n");
            if (this.redactionRuleCol != null) {
                buf.append("import module namespace rdt = \"http://marklogic.com/xdmp/redaction\" at \"/MarkLogic/redaction.xqy\";\n");
            }
            String indent = this.conf.get("mapreduce.marklogic.input.indented", "FALSE");
            Indentation ind = Indentation.valueOf(indent);
            buf.append("declare namespace mlmr=\"http://marklogic.com/hadoop\";\n");
            buf.append("declare variable $mlmr:splitstart as xs:integer external;\n");
            buf.append("declare variable $mlmr:splitend as xs:integer external;\n");
            buf.append(ind.getStatement());
            buf.append("\n");
            String docExpr = this.conf.get("mapreduce.marklogic.input.documentselector");
            String ctsQuery = this.conf.get("mapreduce.marklogic.input.filter.query");
            String subExpr = this.conf.get("mapreduce.marklogic.input.subdocumentexpr");
            Collection collection = nsCol = docExpr != null || subExpr != null ? this.conf.getStringCollection("mapreduce.marklogic.input.namespace") : null;
            if (ctsQuery != null) {
                this.buildSearchQuery(docExpr, ctsQuery, nsCol, buf);
                queryText = buf.toString();
            } else if (docExpr != null || subExpr != null) {
                this.buildDocExprQuery(docExpr, nsCol, subExpr, buf);
                queryText = buf.toString();
            } else {
                LexiconFunction function = null;
                Class lexiconClass = this.conf.getClass("mapreduce.marklogic.input.lexiconfunctionclass", null, LexiconFunction.class);
                if (lexiconClass != null) {
                    function = (LexiconFunction)ReflectionUtils.newInstance((Class)lexiconClass, (Configuration)this.conf);
                    if (nsCol == null) {
                        nsCol = this.conf.getStringCollection("mapreduce.marklogic.input.namespace");
                    }
                    queryText = function.getInputQuery(nsCol, start, this.mlSplit.isLastSplit() ? Long.MAX_VALUE : (long)this.length);
                }
            }
            if (queryText == null) {
                this.buildDocExprQuery(docExpr, nsCol, subExpr, buf);
                queryText = buf.toString();
            }
        } else {
            queryText = this.conf.get("mapreduce.marklogic.input.query");
            queryLanguage = this.conf.get("mapreduce.marklogic.input.querylanguage");
            if (queryText == null) {
                throw new IllegalStateException("Input query is required in advanced mode but not defined.");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)queryText);
        }
        while (this.retry < 15) {
            try {
                String ts;
                if (this.retry == 1) {
                    LOG.info((Object)"Retrying connect");
                }
                String curForestName = "";
                String curHostName = "";
                if (this.curForest == -1) {
                    curForestName = this.mlSplit.getForestId().toString();
                    curHostName = this.hostNames[0];
                } else {
                    curForestName = this.replicas.get(this.curForest).getForest();
                    curHostName = this.replicas.get(this.curForest).getHostName();
                }
                ContentSource cs = InternalUtilities.getInputContentSource(this.conf, curHostName);
                this.session = cs.newSession("#" + curForestName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Connect to forest " + curForestName + " on " + this.session.getConnectionUri().getHost()));
                }
                AdhocQuery query = this.session.newAdhocQuery(queryText);
                if (advancedMode) {
                    boolean bindSplitRange = this.conf.getBoolean("mapreduce.marklogic.input.bindsplitrange", false);
                    if (bindSplitRange) {
                        query.setNewIntegerVariable("http://marklogic.com/hadoop", "splitstart", start);
                        query.setNewIntegerVariable("http://marklogic.com/hadoop", "splitend", end);
                    } else {
                        query.setPosition(start);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("split start position: " + start));
                        }
                        query.setCount(this.mlSplit.isLastSplit() ? Long.MAX_VALUE : this.mlSplit.getLength());
                    }
                } else {
                    query.setNewIntegerVariable("http://marklogic.com/hadoop", "splitstart", start);
                    query.setNewIntegerVariable("http://marklogic.com/hadoop", "splitend", end);
                }
                RequestOptions options = new RequestOptions();
                options.setCacheResult(false);
                if (queryLanguage != null) {
                    options.setQueryLanguage(queryLanguage);
                }
                if ((ts = this.conf.get("mapreduce.marklogic.input.querytimestamp")) != null) {
                    options.setEffectivePointInTime(new BigInteger(ts));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Query timestamp: " + ts));
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Input query: " + query.getQuery()));
                }
                query.setOptions(options);
                this.result = this.session.submitRequest((Request)query);
                break;
            }
            catch (XccConfigException e) {
                LOG.error((Object)("XccConfigException:" + (Object)((Object)e)));
                throw new IOException(e);
            }
            catch (QueryException e) {
                LOG.error((Object)("QueryException:" + (Object)((Object)e)));
                throw new IOException(e);
            }
            catch (RequestException e) {
                LOG.error((Object)("RequestException:" + e.getMessage()));
                if (this.curForest != -1) {
                    if (++this.retry < 15) {
                        try {
                            InternalUtilities.sleep(this.sleepTime);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.sleepTime = Math.min(this.sleepTime * 2, 30000);
                        this.curForest = (this.curForest + 1) % this.replicas.size();
                        continue;
                    }
                    LOG.info((Object)"Exceeded max retry");
                }
                LOG.info((Object)("Query: " + queryText));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RequestException: " + (Object)((Object)e)));
                }
                throw new IOException(e);
            }
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        this.retry = 0;
        this.sleepTime = 500;
        while (this.retry < 15) {
            try {
                if (this.result != null && this.result.hasNext()) {
                    ResultItem item = this.result.next();
                    boolean ret = this.nextResult(item);
                    ++this.count;
                    return ret;
                }
                this.endOfResult();
                return false;
            }
            catch (RuntimeException e) {
                LOG.error((Object)("RuntimeException:" + e.getMessage()));
                if (this.curForest != -1) {
                    if (++this.retry < 15) {
                        try {
                            InternalUtilities.sleep(this.sleepTime);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.sleepTime = Math.min(this.sleepTime * 2, 30000);
                        this.curForest = (this.curForest + 1) % this.replicas.size();
                        this.init();
                        continue;
                    }
                    LOG.info((Object)"Exceeded max retry");
                }
                throw e;
            }
        }
        this.endOfResult();
        return false;
    }

    protected abstract void endOfResult();

    protected abstract boolean nextResult(ResultItem var1);

    protected abstract float getDefaultRatio();

    public long getCount() {
        return this.count;
    }
}

