/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.ForestDocument;
import com.marklogic.mapreduce.MarkLogicNode;
import com.marklogic.tree.ExpandedTree;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;

public class JSONDocument
extends ForestDocument {
    public static final Log LOG = LogFactory.getLog(JSONDocument.class);
    private static TransformerFactory transformerFactory = null;
    private ExpandedTree tree;
    private byte rootNodeKind;
    private String str;

    private static synchronized TransformerFactory getTransformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }

    public JSONDocument() {
    }

    public JSONDocument(ExpandedTree tree) {
        this.tree = tree;
        this.rootNodeKind = tree.rootNodeKind();
        this.str = tree.toString();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.tree = new ExpandedTree();
        this.tree.readFields(in);
        this.rootNodeKind = this.tree.rootNodeKind();
        this.str = this.tree.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.tree.write(out);
    }

    public String toString() {
        return this.str;
    }

    @Override
    public byte[] getContentAsByteArray() {
        return this.str.getBytes();
    }

    @Override
    public Text getContentAsText() {
        return new Text(this.toString());
    }

    @Override
    public ContentType getContentType() {
        if (this.rootNodeKind == 13 || this.rootNodeKind == 14 || this.rootNodeKind == 10 || this.rootNodeKind == 11 || this.rootNodeKind == 12) {
            return ContentType.JSON;
        }
        if (this.rootNodeKind == 2) {
            return ContentType.TEXT;
        }
        throw new UnsupportedOperationException("Unknown node kind: " + this.rootNodeKind);
    }

    @Override
    public MarkLogicNode getContentAsMarkLogicNode() {
        throw new UnsupportedOperationException("Unknown node kind: " + this.rootNodeKind);
    }

    @Override
    public String getContentAsString() throws UnsupportedEncodingException {
        return this.toString();
    }

    @Override
    public Content createContent(String uri, ContentCreateOptions options, boolean copyCollections, boolean copyMetadata, boolean copyQuality) throws IOException {
        if (copyCollections || copyMetadata || copyQuality) {
            this.setContentOptions(options, copyCollections, copyMetadata, copyQuality);
        }
        return ContentFactory.newContent((String)uri, (byte[])this.getContentAsByteArray(), (ContentCreateOptions)options);
    }
}

