/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.io.BiendianDataInputStream;
import com.marklogic.mapreduce.DocumentURIWithSourceInfo;
import com.marklogic.mapreduce.ForestReader;
import com.marklogic.mapreduce.MarkLogicConstants;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class ForestInputFormat<VALUE>
extends FileInputFormat<DocumentURIWithSourceInfo, VALUE>
implements MarkLogicConstants {
    public static final Log LOG = LogFactory.getLog(ForestInputFormat.class);

    public RecordReader<DocumentURIWithSourceInfo, VALUE> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new ForestReader();
    }

    protected List<FileStatus> listStatus(JobContext job) throws IOException {
        List result = super.listStatus(job);
        Iterator it = result.iterator();
        while (it.hasNext()) {
            FileStatus file = (FileStatus)it.next();
            String fileName = file.getPath().getName();
            if (!file.isDirectory() && fileName.equals("Obsolete")) {
                LOG.warn((Object)("Obsolete file found.  The forest is either live or isn't dismounted cleanly.  Ignoring forest " + file.getPath().getParent()));
                return Collections.emptyList();
            }
            if (file.isDirectory() && !fileName.equals("Journals") && !fileName.equals("Large")) continue;
            it.remove();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InputSplit> getSplits(JobContext job) throws IOException {
        long minSize = Math.max(this.getFormatMinSplitSize(), ForestInputFormat.getMinSplitSize((JobContext)job));
        long maxSize = ForestInputFormat.getMaxSplitSize((JobContext)job);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        List<FileStatus> files = this.listStatus(job);
        for (FileStatus file : files) {
            long treeDataSize;
            Path path = file.getPath();
            FileSystem fs = path.getFileSystem(job.getConfiguration());
            FileStatus[] children = fs.listStatus(path);
            FileStatus treeIndexStatus = null;
            FileStatus treeDataStatus = null;
            FileStatus ordinalsStatus = null;
            FileStatus timestampsStatus = null;
            FileStatus qualStatus = null;
            boolean obsolete = false;
            for (FileStatus child : children) {
                String fileName = child.getPath().getName();
                if (fileName.equals("TreeData")) {
                    treeDataStatus = child;
                    continue;
                }
                if (fileName.equals("TreeIndex")) {
                    treeIndexStatus = child;
                    continue;
                }
                if (fileName.equals("Ordinals")) {
                    ordinalsStatus = child;
                    continue;
                }
                if (fileName.equals("Timestamps")) {
                    timestampsStatus = child;
                    continue;
                }
                if (fileName.equals("Obsolete")) {
                    obsolete = true;
                    break;
                }
                if (!fileName.equals("Qualities")) continue;
                qualStatus = child;
            }
            if (obsolete) {
                LOG.warn((Object)("Obsolete file found.  The forest is either live or isn't dismounted cleanly.  Ignoring stand " + path));
                break;
            }
            if (treeDataStatus == null) {
                throw new RuntimeException("TreeData file not found.");
            }
            if (treeIndexStatus == null) {
                throw new RuntimeException("TreeIndex file not found.");
            }
            if (ordinalsStatus == null) {
                throw new RuntimeException("Ordinals file not found.");
            }
            if (timestampsStatus == null) {
                throw new RuntimeException("Timestamps file not found.");
            }
            if (qualStatus == null) {
                LOG.warn((Object)"Qualities file is not found.");
            }
            if ((treeDataSize = treeDataStatus.getLen()) == 0L) {
                LOG.warn((Object)"Found empty TreeData file.  Skipping...");
                continue;
            }
            Path treeDataPath = treeDataStatus.getPath();
            long blockSize = treeDataStatus.getBlockSize();
            long splitSize = this.computeSplitSize(blockSize, minSize, maxSize);
            FSDataInputStream is = fs.open(treeIndexStatus.getPath());
            BiendianDataInputStream in = new BiendianDataInputStream((InputStream)is);
            int prevDocid = -1;
            int docid = -1;
            int position = 0;
            long prevOffset = -1L;
            long offset = 0L;
            long splitStart = 0L;
            BlockLocation[] blkLocations = fs.getFileBlockLocations(treeDataStatus, 0L, treeDataSize);
            try {
                while (true) {
                    FileSplit split;
                    int blkIndex;
                    try {
                        docid = in.readInt();
                        in.readInt();
                        offset = in.readLong();
                    }
                    catch (EOFException e) {
                        break;
                    }
                    int comp = InternalUtilities.compareUnsignedLong(offset, treeDataSize);
                    if (comp > 0) {
                        throw new RuntimeException("TreeIndex offset is out of bound: position = " + position + ", offset = " + offset + ", treeDataSize = " + treeDataSize);
                    }
                    if (prevDocid != -1 && ((long)docid & 0xFFFFFFFFL) <= ((long)prevDocid & 0xFFFFFFFFL)) {
                        throw new RuntimeException("docid out of order, position = " + position + ", docid = " + docid + ", prevDocid = " + prevDocid);
                    }
                    prevDocid = docid;
                    if (prevOffset != -1L && InternalUtilities.compareUnsignedLong(offset, prevOffset) <= 0) {
                        throw new RuntimeException("offset out of order, position = " + position + ", offset = " + offset + ", prevOffset = " + prevOffset);
                    }
                    long splitLen = offset - splitStart;
                    if (splitLen == splitSize || splitLen > splitSize && splitLen - splitSize <= splitSize - (prevOffset - splitStart)) {
                        blkIndex = this.getBlockIndex(blkLocations, offset);
                        split = new FileSplit(treeDataPath, splitStart, splitLen, blkLocations[blkIndex].getHosts());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Created split: start=" + splitStart + " len=" + splitLen + " last docid=" + docid));
                        }
                        splits.add((InputSplit)split);
                        splitStart = offset;
                    } else if (splitLen > splitSize) {
                        blkIndex = this.getBlockIndex(blkLocations, prevOffset);
                        split = new FileSplit(treeDataPath, splitStart, prevOffset - splitStart, blkLocations[blkIndex].getHosts());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Created split: start=" + splitStart + " len=" + (prevOffset - splitStart) + " last docid=" + docid));
                        }
                        splits.add((InputSplit)split);
                        splitStart = prevOffset;
                    }
                    ++position;
                }
            }
            finally {
                in.close();
            }
            if (offset <= splitStart) continue;
            int blkIndex = this.getBlockIndex(blkLocations, offset - 1L);
            FileSplit split = new FileSplit(treeDataPath, splitStart, offset - splitStart, blkLocations[blkIndex].getHosts());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Created split: start=" + splitStart + " len=" + (offset - splitStart) + " last docid=" + docid));
            }
            splits.add((InputSplit)split);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Made " + splits.size() + " splits."));
        }
        return splits;
    }
}

