/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.io.IOHelper;
import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.InternalConstants;
import com.marklogic.mapreduce.MarkLogicDocument;
import com.marklogic.mapreduce.MarkLogicNode;
import com.marklogic.xcc.ResultItem;
import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.XdmBinary;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;

public class DatabaseDocument
implements MarkLogicDocument,
InternalConstants {
    public static final Log LOG = LogFactory.getLog(DatabaseDocument.class);
    protected byte[] content;
    protected InputStream is;
    protected ContentType contentType;

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public Text getContentAsText() {
        if (this.contentType == ContentType.XML || this.contentType == ContentType.JSON || this.contentType == ContentType.TEXT) {
            return new Text(this.content);
        }
        throw new UnsupportedOperationException("Cannot convert binary data to Text.");
    }

    @Override
    public byte[] getContentAsByteArray() {
        if (this.content == null) {
            try {
                this.content = IOHelper.byteArrayFromStream((InputStream)this.is);
            }
            catch (IOException e) {
                throw new RuntimeException("IOException buffering binary data", e);
            }
            this.is = null;
        }
        return this.content;
    }

    @Override
    public InputStream getContentAsByteStream() {
        if (this.is != null) {
            return this.is;
        }
        return new ByteArrayInputStream(this.getContentAsByteArray());
    }

    @Override
    public MarkLogicNode getContentAsMarkLogicNode() {
        if (this.contentType == ContentType.XML || this.contentType == ContentType.TEXT) {
            return new MarkLogicNode(this.getContentAsText().toString(), this.contentType);
        }
        throw new UnsupportedOperationException("Cannot convert JSON or binary data to MarkLogicNode.");
    }

    @Override
    public String getContentAsString() throws UnsupportedEncodingException {
        if (this.contentType == ContentType.XML || this.contentType == ContentType.JSON || this.contentType == ContentType.TEXT) {
            return new String(this.content, "UTF-8");
        }
        throw new UnsupportedOperationException("Cannot convert binary data to String.");
    }

    public void set(ResultItem item) {
        try {
            if (item.getValueType() == ValueType.DOCUMENT) {
                this.content = item.asString().getBytes("UTF-8");
                this.contentType = ContentType.XML;
            } else if (item.getValueType() == ValueType.ELEMENT) {
                this.content = item.asString().getBytes("UTF-8");
                this.contentType = ContentType.XML;
            } else if (item.getValueType() == ValueType.TEXT) {
                this.content = item.asString().getBytes("UTF-8");
                this.contentType = ContentType.TEXT;
            } else if (item.getValueType() == ValueType.BINARY) {
                if (item.isCached()) {
                    this.content = ((XdmBinary)item.getItem()).asBinaryData();
                } else {
                    this.is = item.asInputStream();
                }
                this.contentType = ContentType.BINARY;
            } else if (item.getValueType() == ValueType.ARRAY_NODE || item.getValueType() == ValueType.BOOLEAN_NODE || item.getValueType() == ValueType.NULL_NODE || item.getValueType() == ValueType.NUMBER_NODE || item.getValueType() == ValueType.OBJECT_NODE) {
                this.content = item.asString().getBytes("UTF-8");
                this.contentType = ContentType.JSON;
            } else {
                this.contentType = ContentType.UNKNOWN;
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e);
        }
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public void setContentType(ContentType type) {
        this.contentType = type;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int ordinal = in.readInt();
        this.contentType = ContentType.valueOf(ordinal);
        int length = WritableUtils.readVInt((DataInput)in);
        if (length > 0x1000000) {
            this.is = (DataInputStream)in;
            return;
        }
        this.content = new byte[length];
        in.readFully(this.content, 0, length);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.contentType.ordinal());
        if (this.content != null) {
            WritableUtils.writeVInt((DataOutput)out, (int)this.content.length);
            out.write(this.content, 0, this.content.length);
        } else if (this.is != null) {
            this.content = new byte[0x1000000];
            int len = 0;
            while ((len = this.is.read(this.content)) > 0) {
                out.write(this.content, 0, len);
            }
        }
    }

    @Override
    public long getContentSize() {
        if (this.content != null) {
            return this.content.length;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isStreamable() {
        return this.content == null;
    }
}

