/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.dom;

import com.marklogic.dom.AttrImpl;
import com.marklogic.dom.AttributeNodeMapImpl;
import com.marklogic.dom.NodeImpl;
import com.marklogic.tree.ExpandedTree;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends NodeImpl
implements Element {
    public static final Log LOG = LogFactory.getLog(ElementImpl.class);
    protected AttributeNodeMapImpl attributes = new AttributeNodeMapImpl(this);
    protected int numNSDecl = -1;

    public ElementImpl(ExpandedTree tree, int node) {
        super(tree, node);
    }

    @Override
    protected Node cloneNode(Document doc, boolean deep) {
        Element elem = doc.createElementNS(this.getNamespaceURI(), this.getTagName());
        elem.setPrefix(this.getPrefix());
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            Attr attr = (Attr)this.attributes.item(i);
            if (attr instanceof AttrImpl) {
                elem.setAttributeNode((Attr)((AttrImpl)attr).cloneNode(doc, deep));
                continue;
            }
            Attr clonedAttr = doc.createAttributeNS("http://www.w3.org/2000/xmlns/", attr.getName());
            clonedAttr.setValue(attr.getValue());
            elem.setAttributeNode(clonedAttr);
        }
        if (deep) {
            NodeList list = this.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                NodeImpl n = (NodeImpl)list.item(i);
                Node c = n.cloneNode(doc, true);
                elem.appendChild(c);
            }
        }
        return elem;
    }

    @Override
    public String getAttribute(String name) {
        Attr attr = this.getAttributeNode(name);
        return attr == null ? "" : attr.getValue();
    }

    @Override
    public Attr getAttributeNode(String name) {
        return this.attributes == null ? null : (Attr)this.attributes.getNamedItem(name);
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return this.attributes == null ? null : (AttrImpl)this.getAttributes().getNamedItemNS(namespaceURI, localName);
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) {
        if (this.attributes == null) {
            return "";
        }
        AttrImpl attr = (AttrImpl)this.getAttributes().getNamedItemNS(namespaceURI, localName);
        return attr == null ? "" : attr.getValue();
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.attributes;
    }

    @Override
    public NodeList getChildNodes() {
        return new NodeList(){

            @Override
            public int getLength() {
                return ElementImpl.this.tree.elemNodeNumChildren[ElementImpl.this.tree.nodeRepID[ElementImpl.this.node]];
            }

            @Override
            public Node item(int index) {
                return index < this.getLength() ? ElementImpl.this.tree.node(ElementImpl.this.tree.elemNodeChildNodeRepID[ElementImpl.this.tree.nodeRepID[ElementImpl.this.node]] + index) : null;
            }
        };
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        short type;
        Attr attr;
        String namespace = this.getNamespaceURI();
        String prefix = this.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            if (namespaceURI == null) {
                return namespace == namespaceURI;
            }
            return namespaceURI.equals(namespace);
        }
        if (this.hasAttributes() && (attr = this.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns")) != null) {
            String value = attr.getNodeValue();
            if (namespaceURI == null) {
                return namespace == value;
            }
            return namespaceURI.equals(value);
        }
        Node ancestor = this.getParentNode();
        if (ancestor != null && (type = ancestor.getNodeType()) == 0) {
            return ancestor.isDefaultNamespace(namespaceURI);
        }
        return false;
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String name) {
        return this.getElementsByTagNameNSOrNodeName(namespaceURI, name, false);
    }

    @Override
    public NodeList getElementsByTagName(String localName) {
        return this.getElementsByTagNameNSOrNodeName(null, localName, true);
    }

    protected int getNumChildren() {
        return this.tree.elemNodeNumChildren[this.tree.nodeRepID[this.node]];
    }

    protected int getFirstChildIndex() {
        return this.tree.elemNodeChildNodeRepID[this.tree.nodeRepID[this.node]];
    }

    @Override
    public Node getFirstChild() {
        return this.tree.node(this.getFirstChildIndex());
    }

    @Override
    public Node getLastChild() {
        return this.tree.node(this.tree.elemNodeChildNodeRepID[this.tree.nodeRepID[this.node]] + this.tree.elemNodeNumChildren[this.tree.nodeRepID[this.node]] - 1);
    }

    @Override
    public String getLocalName() {
        return this.tree.atomString(this.tree.nodeNameNameAtom[this.tree.elemNodeNodeNameRepID[this.tree.nodeRepID[this.node]]]);
    }

    @Override
    public String getNamespaceURI() {
        return this.tree.atomString(this.tree.nodeNameNamespaceAtom[this.tree.elemNodeNodeNameRepID[this.tree.nodeRepID[this.node]]]);
    }

    @Override
    public Node getNextChild(int child) {
        return child - this.tree.elemNodeChildNodeRepID[this.tree.nodeRepID[this.node]] + 1 < this.tree.elemNodeNumChildren[this.tree.nodeRepID[this.node]] ? this.tree.node(child + 1) : null;
    }

    @Override
    public String getNodeName() {
        String ns = this.getPrefix();
        return ns == null || ns.equals("") ? this.getTagName() : ns + ":" + this.getTagName();
    }

    @Override
    protected int getPrefixID(int uriAtom) {
        int a = -1;
        boolean useDefaultNS = true;
        ArrayList<Integer> ubp = new ArrayList<Integer>();
        long minOrdinal = 0L;
        int ns = this.getNSNodeID(this.tree.nodeOrdinal[this.node]);
        while (ns >= 0) {
            int uri = this.tree.nsNodeUriAtom[ns];
            int prefix = this.tree.nsNodePrefixAtom[ns];
            if (this.tree.atomString(uri) == null) {
                ubp.add(prefix);
            } else if (uri != uriAtom) {
                useDefaultNS &= this.tree.atomString(prefix) != null;
            } else if (!ubp.contains(prefix)) {
                if (this.tree.atomString(prefix) != null) {
                    if (a == -1) {
                        a = prefix;
                    }
                } else if (useDefaultNS) {
                    return prefix;
                }
            }
            ns = this.nextNSNodeID(ns, minOrdinal);
        }
        return a;
    }

    public int getNumNSDecl() {
        if (this.numNSDecl != -1) {
            return this.numNSDecl;
        }
        this.numNSDecl = 0;
        long minOrdinal = this.tree.nodeOrdinal[this.node];
        int ns = this.getNSNodeID(minOrdinal, minOrdinal);
        while (ns >= 0) {
            ++this.numNSDecl;
            ns = this.nextNSNodeID(ns, minOrdinal);
        }
        return this.numNSDecl;
    }

    @Override
    public String getPrefix() {
        int ns = this.tree.nodeNameNamespaceAtom[this.tree.elemNodeNodeNameRepID[this.tree.nodeRepID[this.node]]];
        if (ns < 0) {
            return null;
        }
        String preserved = this.builtinNSPrefix(this.getNamespaceURI());
        if (preserved != null) {
            return preserved;
        }
        if (this.tree.atomString(ns) != null) {
            ns = this.getPrefixID(ns);
        }
        String r = ns >= 0 ? this.tree.atomString(ns) : null;
        return r;
    }

    @Override
    protected Node getPreviousChild(int child) {
        return child != this.tree.elemNodeChildNodeRepID[this.tree.nodeRepID[this.node]] ? this.tree.node(child - 1) : null;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public String getTagName() {
        return this.tree.atomString(this.tree.nodeNameNameAtom[this.tree.elemNodeNodeNameRepID[this.tree.nodeRepID[this.node]]]);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.getAttributes().getNamedItem(name) != null;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        return this.getAttributes().getNamedItemNS(namespaceURI, localName) != null;
    }

    @Override
    public boolean hasAttributes() {
        return this.getAttributes().getLength() > 0;
    }

    @Override
    public boolean hasChildNodes() {
        return this.getChildNodes().getLength() > 0;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        if (prefix == null) {
            return null;
        }
        if (prefix.equals(this.getPrefix())) {
            return this.getNamespaceURI();
        }
        long minOrdinal = 0L;
        int ns = this.getNSNodeID(this.tree.nodeOrdinal[this.node]);
        while (ns >= 0) {
            int uri = this.tree.nsNodeUriAtom[ns];
            int pf = this.tree.nsNodePrefixAtom[ns];
            if (this.tree.atomString(uri) != null && prefix.equals(this.tree.atomString(pf))) {
                return this.tree.atomString(uri);
            }
            ns = this.nextNSNodeID(ns, minOrdinal);
        }
        return null;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            return null;
        }
        if (namespaceURI.equals(this.getNamespaceURI())) {
            return this.getPrefix();
        }
        long minOrdinal = 0L;
        int ns = this.getNSNodeID(this.tree.nodeOrdinal[this.node]);
        while (ns >= 0) {
            int uri = this.tree.nsNodeUriAtom[ns];
            int pf = this.tree.nsNodePrefixAtom[ns];
            if (this.tree.atomString(pf) != null && namespaceURI.equals(this.tree.atomString(uri))) {
                return this.tree.atomString(pf);
            }
            ns = this.nextNSNodeID(ns, minOrdinal);
        }
        return null;
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new DOMException(7, null);
    }
}

