/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.impl.JacksonBaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.CtsQueryWriteHandle;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.StreamingContentHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonParserHandle
extends JacksonBaseHandle<JsonParser>
implements OutputStreamSender,
StreamingContentHandle<JsonParser, InputStream>,
JSONReadHandle,
JSONWriteHandle,
StructureReadHandle,
StructureWriteHandle,
CtsQueryWriteHandle,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(JacksonParserHandle.class);
    private JsonParser parser;
    private InputStream content;
    private boolean closed = false;
    private static final int BUFFER_SIZE = 8192;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{JsonParser.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return JsonParser.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                JacksonParserHandle handle = this.isHandled(type) ? new JacksonParserHandle() : null;
                return handle;
            }
        };
    }

    public JacksonParserHandle() {
        this.setResendable(false);
    }

    public JacksonParserHandle withFormat(Format format) {
        this.setFormat(format);
        return this;
    }

    public JacksonParserHandle withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    public JsonParser get() {
        if (this.parser == null) {
            if (this.content == null) {
                throw new IllegalStateException("Handle is not yet populated with content");
            }
            this.parser = this.toContent(this.content);
        }
        return this.parser;
    }

    @Override
    public void set(JsonParser parser) {
        this.parser = parser;
        if (parser == null) {
            this.content = null;
        } else if (parser.getInputSource() instanceof InputStream) {
            this.content = (InputStream)parser.getInputSource();
        }
    }

    public JacksonParserHandle with(JsonParser parser) {
        this.set(parser);
        return this;
    }

    @Override
    public Class<JsonParser> getContentClass() {
        return JsonParser.class;
    }

    @Override
    public JacksonParserHandle newHandle() {
        return new JacksonParserHandle().withMimetype(this.getMimetype());
    }

    public JacksonParserHandle[] newHandleArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new JacksonParserHandle[length];
    }

    public JsonParser[] newArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new JsonParser[length];
    }

    @Override
    public ObjectMapper getMapper() {
        return super.getMapper();
    }

    @Override
    public void setMapper(ObjectMapper mapper) {
        super.setMapper(mapper);
    }

    @Override
    protected OutputStreamSender sendContent() {
        return this;
    }

    @Override
    protected OutputStreamSender sendContent(JsonParser parser) {
        try {
            if (parser == null || parser.nextToken() == null) {
                return null;
            }
            return new OutputStreamSenderImpl(this.getMapper(), parser);
        }
        catch (IOException e) {
            throw new MarkLogicIOException("Failed to parse content", e);
        }
    }

    @Override
    protected void receiveContent(InputStream content) {
        this.content = content;
        if (content == null) {
            this.parser = null;
        }
    }

    @Override
    protected boolean hasContent() {
        return this.content != null || this.parser != null;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        try {
            if (this.parser != null && this.parser.nextToken() != null) {
                JsonGenerator generator = this.getMapper().getFactory().createGenerator(out);
                generator.copyCurrentStructure(this.parser);
                generator.close();
            } else if (this.content != null) {
                byte[] b = new byte[8192];
                int len = 0;
                while ((len = this.content.read(b)) != -1) {
                    out.write(b, 0, len);
                }
                this.content.close();
                this.closed = true;
            }
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    public JsonParser toContent(InputStream serialization) {
        if (serialization == null) {
            return null;
        }
        try {
            return this.getMapper().getFactory().createParser(serialization);
        }
        catch (JsonParseException e) {
            throw new MarkLogicIOException(e);
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    public void close() {
        if (this.content != null && !this.closed) {
            try {
                this.content.close();
            }
            catch (IOException e) {
                logger.error("Failed to close underlying InputStream", (Throwable)e);
                throw new MarkLogicIOException(e);
            }
        }
    }

    private static class OutputStreamSenderImpl
    implements OutputStreamSender {
        private final ObjectMapper mapper;
        private final JsonParser parser;

        private OutputStreamSenderImpl(ObjectMapper mapper, JsonParser parser) {
            this.mapper = mapper;
            this.parser = parser;
        }

        @Override
        public void write(OutputStream out) throws IOException {
            JsonGenerator generator = this.mapper.getFactory().createGenerator(out);
            generator.copyCurrentStructure(this.parser);
            generator.close();
        }
    }
}

