/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicInternalException;
import java.util.regex.Pattern;

public enum Format {
    BINARY,
    JSON,
    TEXT,
    XML,
    UNKNOWN;

    private static final Pattern BINARY_MIMETYPE_PATTERN;
    private static final Pattern JSON_MIMETYPE_PATTERN;
    private static final Pattern XML_MIMETYPE_PATTERN;

    public String getDefaultMimetype() {
        switch (this) {
            case UNKNOWN: {
                return null;
            }
            case BINARY: {
                return "application/octet-stream";
            }
            case JSON: {
                return "application/json";
            }
            case TEXT: {
                return "text/plain";
            }
            case XML: {
                return "application/xml";
            }
        }
        throw new MarkLogicInternalException("Unknown format " + this.toString());
    }

    public String getDefaultExtension() {
        switch (this) {
            case UNKNOWN: {
                return null;
            }
            case BINARY: {
                return "bin";
            }
            case JSON: {
                return "json";
            }
            case TEXT: {
                return "txt";
            }
            case XML: {
                return "xml";
            }
        }
        throw new MarkLogicInternalException("Unknown format " + this.toString());
    }

    public static Format getFromMimetype(String mimeType) {
        if (mimeType == null) {
            return UNKNOWN;
        }
        if (JSON_MIMETYPE_PATTERN.matcher(mimeType).matches()) {
            return JSON;
        }
        if (XML_MIMETYPE_PATTERN.matcher(mimeType).matches()) {
            return XML;
        }
        if (BINARY_MIMETYPE_PATTERN.matcher(mimeType).matches()) {
            return BINARY;
        }
        if (mimeType.startsWith("text/")) {
            return TEXT;
        }
        return UNKNOWN;
    }

    public static Format getFromDataType(String dataType) {
        switch (dataType) {
            case "array": {
                return JSON;
            }
            case "binaryDocument": {
                return BINARY;
            }
            case "jsonDocument": {
                return JSON;
            }
            case "object": {
                return JSON;
            }
            case "textDocument": {
                return TEXT;
            }
            case "xmlDocument": {
                return XML;
            }
        }
        return UNKNOWN;
    }

    static {
        BINARY_MIMETYPE_PATTERN = Pattern.compile("^\\s*application/([^+]+\\+)?(octet-stream|x-unknown-content-type)(\\s*;.*)?$");
        JSON_MIMETYPE_PATTERN = Pattern.compile("^\\s*(application|text)/([^+;]+\\+)?json(\\s*;.*)?$");
        XML_MIMETYPE_PATTERN = Pattern.compile("^\\s*(application|text)/([^+;]+\\+)?xml(\\s*;.*)?$");
    }
}

