/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.impl.UrisReadHandle;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.marker.OperationNotSupported;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrisHandle
extends BaseHandle<Reader, OperationNotSupported>
implements UrisReadHandle,
Iterable<String>,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(UrisHandle.class);
    private Reader reader;
    private BufferedReader bufferedReader;

    public UrisHandle() {
        super.setMimetype("text/uri-list");
    }

    @Override
    protected Class<Reader> receiveAs() {
        return Reader.class;
    }

    @Override
    protected void receiveContent(Reader content) {
        this.reader = content;
    }

    @Override
    public Iterator<String> iterator() {
        if (this.bufferedReader == null) {
            this.bufferedReader = new BufferedReader(this.reader);
        }
        return this.bufferedReader.lines().iterator();
    }

    @Override
    public void close() {
        try {
            if (this.bufferedReader != null) {
                this.bufferedReader.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (this.reader != null) {
                    this.reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

