/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.expression.TransformDef;
import com.marklogic.client.impl.BaseTypeImpl;
import com.marklogic.client.type.PlanColumn;
import java.util.HashMap;
import java.util.Map;

public class TransformDefImpl
implements TransformDef,
BaseTypeImpl.BaseArgImpl {
    private String path;
    private String kind = "mjs";
    private Map<String, Object> params;

    public TransformDefImpl(String path) {
        this.path = path;
    }

    @Override
    public StringBuilder exportAst(StringBuilder strb) {
        ObjectNode node = new ObjectMapper().createObjectNode();
        node.put("path", this.path);
        node.put("kind", this.kind);
        if (this.params != null) {
            node.putPOJO("params", this.prepareParamsDuringExport());
        }
        return strb.append(node);
    }

    private Map<String, Object> prepareParamsDuringExport() {
        HashMap<String, Object> preparedParams = new HashMap<String, Object>();
        ObjectMapper mapper = null;
        for (String key : this.params.keySet()) {
            Object value = this.params.get(key);
            if (value instanceof PlanColumn) {
                String json = ((BaseTypeImpl.BaseArgImpl)value).exportAst(new StringBuilder()).toString();
                if (mapper == null) {
                    mapper = new ObjectMapper();
                }
                try {
                    preparedParams.put(key, mapper.readTree(json));
                    continue;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Unable to prepare parameters while exporting transform definition: " + e.getMessage(), e);
                }
            }
            preparedParams.put(key, value);
        }
        return preparedParams;
    }

    @Override
    public TransformDef withKind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public TransformDef withParams(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    @Override
    public TransformDef withParam(String name, Object value) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(name, value);
        return this;
    }
}

