/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ForbiddenUserException;
import com.marklogic.client.Transaction;
import com.marklogic.client.impl.ClientCookie;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.HandleImplementation;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.marker.StructureReadHandle;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

class TransactionImpl
implements Transaction {
    static final int DEFAULT_TIMELIMIT = -1;
    private RESTServices services;
    private String transactionId;
    private String hostId;
    private List<ClientCookie> cookies = new ArrayList<ClientCookie>();
    private Calendar created;

    TransactionImpl(RESTServices services, String transactionId, List<ClientCookie> cookies) {
        this.services = services;
        this.transactionId = transactionId;
        if (cookies != null) {
            for (ClientCookie cookie : cookies) {
                this.cookies.add(new ClientCookie(cookie));
                if (!"HostId".equalsIgnoreCase(cookie.getName())) continue;
                this.hostId = cookie.getValue();
            }
        }
        this.created = Calendar.getInstance();
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @Override
    public List<ClientCookie> getCookies() {
        return this.cookies;
    }

    @Override
    public String getHostId() {
        return this.hostId;
    }

    protected void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public Calendar getCreatedTimestamp() {
        return this.created;
    }

    @Override
    public <T extends StructureReadHandle> T readStatus(T handle) throws ForbiddenUserException, FailedRequestException {
        if (handle == null) {
            throw new IllegalArgumentException("reading transaction status with null handle");
        }
        HandleImplementation handleBase = HandleAccessor.checkHandle(handle, "structure");
        handleBase.receiveContent(this.services.getValue(null, "transactions", this.getTransactionId(), this, false, handleBase.getMimetype(), handleBase.receiveAs()));
        return handle;
    }

    @Override
    public void commit() throws ForbiddenUserException, FailedRequestException {
        this.services.commitTransaction(this);
    }

    @Override
    public void rollback() throws ForbiddenUserException, FailedRequestException {
        this.services.rollbackTransaction(this);
    }
}

