/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;

public class DocumentWriteOperationImpl
implements DocumentWriteOperation {
    private DocumentWriteOperation.OperationType operationType;
    private String uri;
    private String temporalDocumentURI;
    private DocumentMetadataWriteHandle metadata;
    private AbstractWriteHandle content;

    public DocumentWriteOperationImpl(String uri, DocumentMetadataWriteHandle metadata, AbstractWriteHandle content) {
        this(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, uri, metadata, content, null);
    }

    public DocumentWriteOperationImpl(DocumentWriteOperation.OperationType type, String uri, DocumentMetadataWriteHandle metadata, AbstractWriteHandle content) {
        this(type, uri, metadata, content, null);
    }

    public DocumentWriteOperationImpl(String uri, DocumentMetadataWriteHandle metadata, AbstractWriteHandle content, String temporalDocumentURI) {
        this(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, uri, metadata, content, temporalDocumentURI);
    }

    public DocumentWriteOperationImpl(DocumentWriteOperation.OperationType type, String uri, DocumentMetadataWriteHandle metadata, AbstractWriteHandle content, String temporalDocumentURI) {
        if (type == DocumentWriteOperation.OperationType.DOCUMENT_WRITE && uri == null) {
            throw new IllegalArgumentException("Uri cannot be null when Operation Type is DOCUMENT_WRITE.");
        }
        if (type != DocumentWriteOperation.OperationType.DOCUMENT_WRITE && uri != null) {
            throw new IllegalArgumentException("Operation Type should be DOCUMENT_WRITE when uri is not null");
        }
        this.operationType = type;
        this.uri = uri;
        this.metadata = metadata;
        this.content = content;
        this.temporalDocumentURI = temporalDocumentURI;
    }

    public DocumentWriteOperationImpl(String uri, AbstractWriteHandle content) {
        this(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, uri, null, content, null);
    }

    @Override
    public DocumentWriteOperation.OperationType getOperationType() {
        return this.operationType;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getTemporalDocumentURI() {
        return this.temporalDocumentURI;
    }

    @Override
    public DocumentMetadataWriteHandle getMetadata() {
        return this.metadata;
    }

    @Override
    public AbstractWriteHandle getContent() {
        return this.content;
    }

    @Override
    public int compareTo(DocumentWriteOperation o) {
        if (o == null) {
            throw new NullPointerException("DocumentWriteOperation cannot be null");
        }
        if (this.getUri() != null && o.getUri() != null) {
            return this.getUri().compareTo(o.getUri());
        }
        if (this.getUri() == null && o.getUri() != null) {
            return -1;
        }
        if (this.getUri() != null && o.getUri() == null) {
            return 1;
        }
        if (this.getUri() == null && o.getUri() == null) {
            if (this.hashCode() > o.hashCode()) {
                return 1;
            }
            if (this.hashCode() < o.hashCode()) {
                return -1;
            }
            return 0;
        }
        return 0;
    }

    public int hashCode() {
        if (this.getUri() != null) {
            return this.getUri().hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DocumentWriteOperation)) {
            return false;
        }
        if (this.getUri() == null) {
            return super.equals(o);
        }
        return this.getUri().equals(((DocumentWriteOperation)o).getUri());
    }
}

