/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.extra.okhttpclient.RemoveAcceptEncodingConfigurator;
import com.marklogic.client.impl.SSLUtil;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public class DatabaseClientPropertySource {
    private static final String PREFIX = "marklogic.client.";
    private final Function<String, Object> propertySource;
    private static Map<String, BiConsumer<DatabaseClientFactory.Bean, Object>> connectionPropertyHandlers = new LinkedHashMap<String, BiConsumer<DatabaseClientFactory.Bean, Object>>();

    public DatabaseClientPropertySource(Function<String, Object> propertySource) {
        this.propertySource = propertySource;
    }

    public DatabaseClient newClient() {
        DatabaseClientFactory.Bean bean = this.newClientBean();
        return DatabaseClientFactory.newClient(bean.getHost(), bean.getPort(), bean.getBasePath(), bean.getDatabase(), bean.getSecurityContext(), bean.getConnectionType());
    }

    public DatabaseClientFactory.Bean newClientBean() {
        DatabaseClientFactory.Bean bean = new DatabaseClientFactory.Bean();
        connectionPropertyHandlers.forEach((propName, consumer) -> {
            Object propValue = this.propertySource.apply((String)propName);
            if (propValue != null) {
                consumer.accept(bean, propValue);
            }
        });
        bean.setSecurityContext(this.newSecurityContext());
        return bean;
    }

    private DatabaseClientFactory.SecurityContext newSecurityContext() {
        Object securityContextValue = this.propertySource.apply("marklogic.client.securityContext");
        if (securityContextValue != null) {
            if (securityContextValue instanceof DatabaseClientFactory.SecurityContext) {
                return (DatabaseClientFactory.SecurityContext)securityContextValue;
            }
            throw new IllegalArgumentException("Security context must be of type " + DatabaseClientFactory.SecurityContext.class.getName());
        }
        Object typeValue = this.propertySource.apply("marklogic.client.authType");
        if (typeValue == null || !(typeValue instanceof String)) {
            throw new IllegalArgumentException("Security context should be set, or auth type must be of type String");
        }
        String authType = (String)typeValue;
        SSLUtil.SSLInputs sslInputs = this.buildSSLInputs(authType);
        DatabaseClientFactory.SecurityContext securityContext = this.newSecurityContext(authType, sslInputs);
        if (sslInputs.getSslContext() != null) {
            securityContext.withSSLContext(sslInputs.getSslContext(), sslInputs.getTrustManager());
        }
        securityContext.withSSLHostnameVerifier(this.determineHostnameVerifier());
        return securityContext;
    }

    private DatabaseClientFactory.SecurityContext newSecurityContext(String type, SSLUtil.SSLInputs sslInputs) {
        switch (type.toLowerCase()) {
            case "basic": {
                return this.newBasicAuthContext();
            }
            case "digest": {
                return this.newDigestAuthContext();
            }
            case "cloud": {
                return this.newCloudAuthContext();
            }
            case "kerberos": {
                return this.newKerberosAuthContext();
            }
            case "certificate": {
                return this.newCertificateAuthContext(sslInputs);
            }
            case "saml": {
                return this.newSAMLAuthContext();
            }
            case "oauth": {
                return this.newOAuthContext();
            }
        }
        throw new IllegalArgumentException("Unrecognized auth type: " + type);
    }

    private String getRequiredStringValue(String propertyName) {
        return this.getRequiredStringValue(propertyName, String.format("%s must be of type String", propertyName));
    }

    private String getRequiredStringValue(String propertyName, String errorMessage) {
        Object value = this.propertySource.apply(PREFIX + propertyName);
        if (value == null || !(value instanceof String)) {
            throw new IllegalArgumentException(errorMessage);
        }
        return (String)value;
    }

    private String getNullableStringValue(String propertyName) {
        return this.getNullableStringValue(propertyName, null);
    }

    private String getNullableStringValue(String propertyName, String defaultValue) {
        Object value = this.propertySource.apply(PREFIX + propertyName);
        if (value != null && !(value instanceof String)) {
            throw new IllegalArgumentException(propertyName + " must be of type String");
        }
        return value != null ? (String)value : defaultValue;
    }

    private DatabaseClientFactory.SecurityContext newBasicAuthContext() {
        return new DatabaseClientFactory.BasicAuthContext(this.getRequiredStringValue("username", "Must specify a username when using basic authentication."), this.getRequiredStringValue("password", "Must specify a password when using basic authentication."));
    }

    private DatabaseClientFactory.SecurityContext newDigestAuthContext() {
        return new DatabaseClientFactory.DigestAuthContext(this.getRequiredStringValue("username", "Must specify a username when using digest authentication."), this.getRequiredStringValue("password", "Must specify a password when using digest authentication."));
    }

    private DatabaseClientFactory.SecurityContext newCloudAuthContext() {
        String apiKey = this.getRequiredStringValue("cloud.apiKey");
        String val = this.getNullableStringValue("cloud.tokenDuration");
        Integer duration = null;
        if (val != null) {
            try {
                duration = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cloud token duration must be numeric");
            }
        }
        return new DatabaseClientFactory.MarkLogicCloudAuthContext(apiKey, duration);
    }

    private DatabaseClientFactory.SecurityContext newCertificateAuthContext(SSLUtil.SSLInputs sslInputs) {
        String file = this.getNullableStringValue("certificate.file");
        String password = this.getNullableStringValue("certificate.password");
        if (file != null && file.trim().length() > 0) {
            try {
                if (password != null && password.trim().length() > 0) {
                    return new DatabaseClientFactory.CertificateAuthContext(file, password, sslInputs.getTrustManager());
                }
                return new DatabaseClientFactory.CertificateAuthContext(file, sslInputs.getTrustManager());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create CertificateAuthContext; cause " + e.getMessage(), e);
            }
        }
        if (sslInputs.getSslContext() == null) {
            throw new RuntimeException("An SSLContext is required for certificate authentication.");
        }
        return new DatabaseClientFactory.CertificateAuthContext(sslInputs.getSslContext(), sslInputs.getTrustManager());
    }

    private DatabaseClientFactory.SecurityContext newKerberosAuthContext() {
        return new DatabaseClientFactory.KerberosAuthContext(this.getRequiredStringValue("kerberos.principal"));
    }

    private DatabaseClientFactory.SecurityContext newSAMLAuthContext() {
        return new DatabaseClientFactory.SAMLAuthContext(this.getRequiredStringValue("saml.token"));
    }

    private DatabaseClientFactory.SecurityContext newOAuthContext() {
        return new DatabaseClientFactory.OAuthContext(this.getRequiredStringValue("oauth.token"));
    }

    private DatabaseClientFactory.SSLHostnameVerifier determineHostnameVerifier() {
        Object verifierObject = this.propertySource.apply("marklogic.client.sslHostnameVerifier");
        if (verifierObject instanceof DatabaseClientFactory.SSLHostnameVerifier) {
            return (DatabaseClientFactory.SSLHostnameVerifier)verifierObject;
        }
        if (verifierObject instanceof String) {
            String verifier = (String)verifierObject;
            if ("ANY".equalsIgnoreCase(verifier)) {
                return DatabaseClientFactory.SSLHostnameVerifier.ANY;
            }
            if ("COMMON".equalsIgnoreCase(verifier)) {
                return DatabaseClientFactory.SSLHostnameVerifier.COMMON;
            }
            if ("STRICT".equalsIgnoreCase(verifier)) {
                return DatabaseClientFactory.SSLHostnameVerifier.STRICT;
            }
            throw new IllegalArgumentException(String.format("Unrecognized value for SSLHostnameVerifier: %s", verifier));
        }
        return null;
    }

    private SSLUtil.SSLInputs buildSSLInputs(String authType) {
        X509TrustManager userTrustManager = this.getTrustManager();
        SSLContext sslContext = this.getSSLContext();
        if (sslContext != null) {
            return new SSLUtil.SSLInputs(sslContext, userTrustManager);
        }
        String keyStorePath = this.getNullableStringValue("ssl.keystore.path");
        if (keyStorePath != null && keyStorePath.trim().length() > 0) {
            return this.useKeyStoreForTwoWaySSL(keyStorePath, userTrustManager);
        }
        String sslProtocol = this.getSSLProtocol(authType);
        if (sslProtocol != null) {
            return "default".equalsIgnoreCase(sslProtocol) ? this.useDefaultSSLContext(userTrustManager) : this.useNewSSLContext(sslProtocol, userTrustManager);
        }
        return new SSLUtil.SSLInputs(null, userTrustManager);
    }

    private X509TrustManager getTrustManager() {
        Object val = this.propertySource.apply("marklogic.client.trustManager");
        if (val != null) {
            if (val instanceof X509TrustManager) {
                return (X509TrustManager)val;
            }
            throw new IllegalArgumentException("Trust manager must be an instanceof " + X509TrustManager.class.getName());
        }
        String path = this.getNullableStringValue("ssl.truststore.path");
        if (path != null && path.trim().length() > 0) {
            return this.buildTrustManagerFromTrustStorePath(path);
        }
        return null;
    }

    private X509TrustManager buildTrustManagerFromTrustStorePath(String path) {
        String password = this.getNullableStringValue("ssl.truststore.password");
        String type = this.getNullableStringValue("ssl.truststore.type", "JKS");
        String algorithm = this.getNullableStringValue("ssl.truststore.algorithm", "SunX509");
        KeyStore trustStore = SSLUtil.getKeyStore(path, password != null ? password.toCharArray() : null, type);
        return (X509TrustManager)SSLUtil.getTrustManagers(algorithm, trustStore)[0];
    }

    private SSLContext getSSLContext() {
        Object val = this.propertySource.apply("marklogic.client.sslContext");
        if (val != null) {
            if (val instanceof SSLContext) {
                return (SSLContext)val;
            }
            throw new IllegalArgumentException("SSL context must be an instanceof " + SSLContext.class.getName());
        }
        return null;
    }

    private String getSSLProtocol(String authType) {
        String sslProtocol = this.getNullableStringValue("sslProtocol");
        if (sslProtocol != null) {
            sslProtocol = sslProtocol.trim();
        }
        if ((sslProtocol == null || sslProtocol.length() == 0) && "cloud".equalsIgnoreCase(authType)) {
            sslProtocol = "default";
        }
        return sslProtocol;
    }

    private SSLUtil.SSLInputs useKeyStoreForTwoWaySSL(String keyStorePath, X509TrustManager userTrustManager) {
        String password = this.getNullableStringValue("ssl.keystore.password");
        String keyStoreType = this.getNullableStringValue("ssl.keystore.type", "JKS");
        String algorithm = this.getNullableStringValue("ssl.keystore.algorithm", "SunX509");
        char[] charPassword = password != null ? password.toCharArray() : null;
        String sslProtocol = this.getNullableStringValue("sslProtocol", "TLSv1.2");
        return SSLUtil.createSSLContextFromKeyStore(keyStorePath, charPassword, keyStoreType, algorithm, sslProtocol, userTrustManager);
    }

    private SSLUtil.SSLInputs useDefaultSSLContext(X509TrustManager userTrustManager) {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to obtain default SSLContext; cause: " + e.getMessage(), e);
        }
        X509TrustManager trustManager = userTrustManager != null ? userTrustManager : SSLUtil.getDefaultTrustManager();
        return new SSLUtil.SSLInputs(sslContext, trustManager);
    }

    private SSLUtil.SSLInputs useNewSSLContext(String sslProtocol, X509TrustManager userTrustManager) {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getInstance(sslProtocol);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(String.format("Unable to get SSLContext instance with protocol: %s; cause: %s", sslProtocol, e.getMessage()), e);
        }
        if (userTrustManager != null) {
            try {
                sslContext.init(null, new X509TrustManager[]{userTrustManager}, null);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException(String.format("Unable to initialize SSLContext; protocol: %s; cause: %s", sslProtocol, e.getMessage()), e);
            }
        }
        return new SSLUtil.SSLInputs(sslContext, userTrustManager);
    }

    static {
        connectionPropertyHandlers.put("marklogic.client.host", (bean, value) -> {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("Host must be of type String");
            }
            bean.setHost((String)value);
        });
        connectionPropertyHandlers.put("marklogic.client.port", (bean, value) -> {
            if (value instanceof String) {
                bean.setPort(Integer.parseInt((String)value));
            } else if (value instanceof Integer) {
                bean.setPort((Integer)value);
            } else {
                throw new IllegalArgumentException("Port must be of type String or Integer");
            }
        });
        connectionPropertyHandlers.put("marklogic.client.database", (bean, value) -> {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("Database must be of type String");
            }
            bean.setDatabase((String)value);
        });
        connectionPropertyHandlers.put("marklogic.client.basePath", (bean, value) -> {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("Base path must be of type String");
            }
            bean.setBasePath((String)value);
        });
        connectionPropertyHandlers.put("marklogic.client.connectionType", (bean, value) -> {
            if (value instanceof DatabaseClient.ConnectionType) {
                bean.setConnectionType((DatabaseClient.ConnectionType)((Object)((Object)value)));
            } else if (value instanceof String) {
                String val = (String)value;
                if (val.trim().length() > 0) {
                    bean.setConnectionType(DatabaseClient.ConnectionType.valueOf(val.toUpperCase()));
                }
            } else {
                throw new IllegalArgumentException("Connection type must either be a String or an instance of ConnectionType");
            }
        });
        connectionPropertyHandlers.put("marklogic.client.disableGzippedResponses", (bean, value) -> {
            boolean disableGzippedResponses = false;
            if (value instanceof Boolean && Boolean.TRUE.equals(value)) {
                disableGzippedResponses = true;
            } else if (value instanceof String) {
                disableGzippedResponses = Boolean.parseBoolean((String)value);
            }
            if (disableGzippedResponses) {
                DatabaseClientFactory.addConfigurator(new RemoveAcceptEncodingConfigurator());
            }
        });
    }
}

