/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import java.util.concurrent.TimeUnit;
import okhttp3.Cookie;
import okhttp3.HttpUrl;

public class ClientCookie {
    Cookie cookie;

    ClientCookie(String name, String value, long expiresAt, String domain, String path, boolean secure) {
        Cookie.Builder cookieBldr = new Cookie.Builder().domain(domain).path(path).name(name).value(value).expiresAt(expiresAt);
        if (secure) {
            cookieBldr = cookieBldr.secure();
        }
        this.cookie = cookieBldr.build();
    }

    public ClientCookie(ClientCookie cookie) {
        this(cookie.getName(), cookie.getValue(), cookie.expiresAt(), cookie.getDomain(), cookie.getPath(), cookie.isSecure());
    }

    public boolean isSecure() {
        return this.cookie.secure();
    }

    public String getPath() {
        return this.cookie.path();
    }

    public String getDomain() {
        return this.cookie.domain();
    }

    public long expiresAt() {
        return this.cookie.expiresAt();
    }

    public String getName() {
        return this.cookie.name();
    }

    public int getMaxAge() {
        return (int)TimeUnit.MILLISECONDS.toSeconds(this.cookie.expiresAt() - System.currentTimeMillis());
    }

    public String getValue() {
        return this.cookie.value();
    }

    public static ClientCookie parse(HttpUrl url, String setCookie) {
        Cookie cookie = Cookie.parse((HttpUrl)url, (String)setCookie);
        if (cookie == null) {
            throw new IllegalStateException(setCookie + "is not a well-formed cookie");
        }
        return new ClientCookie(cookie.name(), cookie.value(), cookie.expiresAt(), cookie.domain(), cookie.path(), cookie.secure());
    }

    public String toString() {
        return this.cookie.toString();
    }
}

