/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.dataservices.impl;

import com.marklogic.client.dataservices.impl.CallContextImpl;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.marker.BufferableContentHandle;

public interface HandleProvider<I, O> {
    public BufferableContentHandle<?, ?> getInputHandle();

    public BufferableContentHandle<?, ?> getOutputHandle();

    public I[] newInputArray(int var1);

    public O[] newOutputArray(int var1);

    public BufferableContentHandle<?, ?>[] bufferableInputHandleOn(I[] var1);

    public O[] outputAsArray(CallContextImpl<I, O> var1, RESTServices.MultipleCallResponse var2);

    public static class DirectHandleProvider<IC, IR, OC, OR>
    implements HandleProvider<BufferableContentHandle<IC, IR>, BufferableContentHandle<OC, OR>> {
        private final BufferableContentHandle<IC, IR> inputHandle;
        private final BufferableContentHandle<OC, OR> outputHandle;

        public DirectHandleProvider(BufferableContentHandle<IC, IR> inputHandle, BufferableContentHandle<OC, OR> outputHandle) {
            this.inputHandle = inputHandle;
            this.outputHandle = outputHandle;
        }

        @Override
        public BufferableContentHandle<IC, IR> getInputHandle() {
            return this.inputHandle;
        }

        @Override
        public BufferableContentHandle<OC, OR> getOutputHandle() {
            return this.outputHandle;
        }

        public BufferableContentHandle<IC, IR>[] newInputArray(int length) {
            if (this.inputHandle == null) {
                throw new IllegalStateException("No input handle provided");
            }
            return this.inputHandle.newHandleArray(length);
        }

        public BufferableContentHandle<OC, OR>[] newOutputArray(int length) {
            if (this.outputHandle == null) {
                throw new IllegalStateException("No output handle provided");
            }
            return this.outputHandle.newHandleArray(length);
        }

        public BufferableContentHandle<IC, IR>[] bufferableInputHandleOn(BufferableContentHandle<IC, IR>[] input) {
            return input;
        }

        public BufferableContentHandle<OC, OR>[] outputAsArray(CallContextImpl<BufferableContentHandle<IC, IR>, BufferableContentHandle<OC, OR>> callCtxt, RESTServices.MultipleCallResponse response) {
            if (this.outputHandle == null) {
                throw new IllegalStateException("No output handle provided");
            }
            return response.asArrayOfHandles(callCtxt.getEndpointState(), this.outputHandle);
        }
    }

    public static class ContentHandleProvider<I, O>
    implements HandleProvider<I, O> {
        private final BufferableContentHandle<I, ?> inputHandle;
        private final BufferableContentHandle<O, ?> outputHandle;

        public ContentHandleProvider(BufferableContentHandle<I, ?> inputHandle, BufferableContentHandle<O, ?> outputHandle) {
            this.inputHandle = inputHandle;
            this.outputHandle = outputHandle;
        }

        @Override
        public BufferableContentHandle<I, ?> getInputHandle() {
            return this.inputHandle;
        }

        @Override
        public BufferableContentHandle<O, ?> getOutputHandle() {
            return this.outputHandle;
        }

        @Override
        public I[] newInputArray(int length) {
            if (this.inputHandle == null) {
                throw new IllegalStateException("No input handle provided");
            }
            return this.inputHandle.newArray(length);
        }

        @Override
        public O[] newOutputArray(int length) {
            if (this.outputHandle == null) {
                throw new IllegalStateException("No output handle provided");
            }
            return this.outputHandle.newArray(length);
        }

        @Override
        public BufferableContentHandle<?, ?>[] bufferableInputHandleOn(I[] input) {
            if (this.inputHandle == null) {
                throw new IllegalStateException("No input handle provided");
            }
            return this.inputHandle.resendableHandleFor(input);
        }

        @Override
        public O[] outputAsArray(CallContextImpl<I, O> callCtxt, RESTServices.MultipleCallResponse response) {
            if (this.outputHandle == null) {
                throw new IllegalStateException("No output handle provided");
            }
            return response.asArrayOfContent(callCtxt.isLegacyContext() ? null : callCtxt.getEndpointState(), this.outputHandle);
        }
    }
}

