/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.alerting;

import com.marklogic.client.alerting.RuleDefinition;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.DOMHandle;
import com.marklogic.client.io.marker.OperationNotSupported;
import com.marklogic.client.io.marker.RuleListReadHandle;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RuleDefinitionList
extends BaseHandle<InputStream, OperationNotSupported>
implements Iterable<RuleDefinition>,
RuleListReadHandle {
    private List<RuleDefinition> rules;

    @Override
    public Iterator<RuleDefinition> iterator() {
        return this.rules.iterator();
    }

    public int size() {
        return this.rules.size();
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        this.rules = new ArrayList<RuleDefinition>();
        DOMHandle domHandle = new DOMHandle();
        HandleAccessor.receiveContent(domHandle, content);
        Document document = domHandle.get();
        NodeList ruleNodes = document.getElementsByTagNameNS("http://marklogic.com/rest-api", "rule");
        int ruleNodesLength = ruleNodes.getLength();
        for (int i = 0; i < ruleNodesLength; ++i) {
            Element ruleElement = (Element)ruleNodes.item(i);
            RuleDefinition ruleDefinition = new RuleDefinition();
            ruleDefinition.receiveElement(ruleElement);
            this.rules.add(ruleDefinition);
        }
    }
}

