/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.impl.admin;

import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Marlinserver;
import com.mapr.streams.impl.admin.CursorInfo;
import java.util.ArrayList;
import java.util.List;

public class TopicFeedInfo {
    private static final long MARLIN_INVALID_SEQNUM = -1L;
    Marlinserver.TopicFeedStatInfo stat;
    List<CursorInfo> cursorList;

    public TopicFeedInfo(Marlinserver.TopicFeedStatInfo sinfo, List<CursorInfo> cursorList) {
        this.stat = sinfo;
        this.cursorList = cursorList;
    }

    public TopicFeedInfo(int feedId) {
        this.stat = Marlinserver.TopicFeedStatInfo.newBuilder().setFeedId(feedId).build();
        this.cursorList = new ArrayList<CursorInfo>();
    }

    public Marlinserver.TopicFeedStatInfo stat() {
        return this.stat;
    }

    public void updateStat(Marlinserver.TopicFeedStatInfo statNew) {
        Marlinserver.TopicFeedStatInfo merged;
        this.stat = merged = this.mergeStats(this.stat, statNew);
    }

    private Marlinserver.TopicFeedStatInfo mergeStats(Marlinserver.TopicFeedStatInfo s1, Marlinserver.TopicFeedStatInfo s2) {
        Marlinserver.TopicFeedStatInfo.Builder minfo = Marlinserver.TopicFeedStatInfo.newBuilder();
        minfo.setFeedId(s1.getFeedId());
        long psize = s1.getPhysicalSize() + s2.getPhysicalSize();
        minfo.setPhysicalSize(psize);
        long lsize = s1.getLogicalSize() + s2.getLogicalSize();
        minfo.setLogicalSize(lsize);
        long minSeq = Math.min(s1.getMinSeq(), s2.getMinSeq());
        minfo.setMinSeq(minSeq);
        if (s2.getMaxSeq() == -1L) {
            minfo.setMaxSeq(-1L);
        } else {
            long maxSeq = Math.max(s1.getMaxSeq(), s2.getMaxSeq());
            minfo.setMaxSeq(maxSeq);
        }
        long tmin = 0L;
        long tmax = 0L;
        if (s1.hasTimeRange() && s2.hasTimeRange()) {
            tmin = Math.min(s1.getTimeRange().getMinTS(), s2.getTimeRange().getMinTS());
            tmax = Math.max(s1.getTimeRange().getMaxTS(), s2.getTimeRange().getMaxTS());
        } else if (s1.hasTimeRange()) {
            tmin = s1.getTimeRange().getMinTS();
            tmax = s1.getTimeRange().getMaxTS();
        } else if (s2.hasTimeRange()) {
            tmin = s2.getTimeRange().getMinTS();
            tmax = s2.getTimeRange().getMaxTS();
        }
        if (tmax != 0L) {
            Dbserver.TimeRange trange = Dbserver.TimeRange.newBuilder().setMinTS(tmin).setMaxTS(tmax).build();
            minfo.setTimeRange(trange);
        }
        Marlinserver.TopicFeedStatInfo copyFrom = s1;
        if (s2.getMaxSeq() > s1.getMaxSeq() || s2.getMaxSeq() == -1L) {
            copyFrom = s2;
        }
        if (copyFrom.hasFid()) {
            minfo.setFid(copyFrom.getFid());
        }
        if (copyFrom.hasMaster()) {
            minfo.setMaster(copyFrom.getMaster());
        }
        if (copyFrom.hasMasterPort()) {
            minfo.setMasterPort(copyFrom.getMasterPort());
        }
        minfo.addAllServers((Iterable)copyFrom.getServersList());
        minfo.addAllServerPorts((Iterable)copyFrom.getServerPortsList());
        return minfo.build();
    }

    public void addCursor(CursorInfo ci) {
        this.cursorList.add(ci);
    }

    public List<CursorInfo> cursorList() {
        return this.cursorList;
    }
}

