/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.hadoop.yarn.nodemanager;

import com.mapr.hadoop.yarn.util.YarnAppUtil;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.security.ExternalTokenLocalizer;

public class MapRTicketLocalizer
implements ExternalTokenLocalizer {
    private static final Log LOG = LogFactory.getLog(MapRTicketLocalizer.class);
    private ConcurrentHashMap<ApplicationId, AtomicBoolean> accessKeyMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ContainerId containerId, String username, Configuration conf) {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        AtomicBoolean accessKey = this.getAccessKey(containerId.getApplicationAttemptId().getApplicationId());
        if (accessKey.get()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Ticket already localized for " + containerId));
            }
            return;
        }
        AtomicBoolean atomicBoolean = accessKey;
        synchronized (atomicBoolean) {
            if (accessKey.get()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Ticket already localized for " + containerId));
                }
                return;
            }
            try {
                this.localizeUserTicket(containerId, username, conf);
                accessKey.set(true);
            }
            catch (IOException e) {
                throw new YarnRuntimeException((Throwable)e);
            }
        }
    }

    private AtomicBoolean getAccessKey(ApplicationId appId) {
        AtomicBoolean accessKey = new AtomicBoolean(false);
        AtomicBoolean existingAccessKey = this.accessKeyMap.putIfAbsent(appId, accessKey);
        if (existingAccessKey != null) {
            accessKey = existingAccessKey;
        }
        return accessKey;
    }

    public Path getTokenPath(String appIdStr, Configuration conf) {
        return UserGroupInformation.isSecurityEnabled() ? YarnAppUtil.getNMPrivateTicketPath(appIdStr, conf) : null;
    }

    public String getTokenEnvVar() {
        return "MAPR_TICKETFILE_LOCATION";
    }

    private void localizeUserTicket(ContainerId containerId, String username, Configuration conf) throws IOException {
        String appIdStr = containerId.getApplicationAttemptId().getApplicationId().toString();
        Path localTicketPath = YarnAppUtil.getNMPrivateTicketPath(appIdStr, conf);
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path ticketPath = YarnAppUtil.getRMSystemMapRTicketPath(appIdStr, fs, conf);
        fs.copyToLocalFile(ticketPath, localTicketPath);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Localized user ticket file from " + ticketPath.toUri().getPath() + " to " + localTicketPath.toUri().getPath()));
        }
    }

    public void cleanup(ApplicationId appId) {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        this.accessKeyMap.remove(appId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Cleanup complete for " + appId));
        }
    }
}

