/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.hadoop.conf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.util.ConfigUtil;

public class HadoopConfigClassifier {
    private static final String CORE_DEFAULT_XML = "core-default.xml";
    private static final String MAPRED_DEFAULT_XML = "mapred-default.xml";
    private static final String YARN_DEFAULT_XML = "yarn-default.xml";
    private static final String CORE_DEFAULT_PROPERTIES = "org.apache.hadoop.conf.CoreDefaultProperties";
    private static final String MAPRED_DEFAULT_PROPERTIES = "org.apache.hadoop.mapreduce.conf.MapReduceDefaultProperties";
    private static final String YARN_DEFAULT_PROPERTIES = "org.apache.hadoop.yarn.conf.YarnDefaultProperties";
    private static final String CORE_SITE_XML = "core-site.xml";
    private static final String MAPRED_SITE_XML = "mapred-site.xml";
    private static final String YARN_SITE_XML = "yarn-site.xml";
    private static Map<String, ConfigOption> OPTIONS = new HashMap<String, ConfigOption>();
    public static final int PADDING = 40;

    private static String getPadding(ConfigOption option) {
        int padding = 40 - option.option.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < padding; ++i) {
            builder.append(" ");
        }
        return builder.toString();
    }

    private static String indent(String line) {
        String[] splits = line.split("\\{\\}");
        if (splits.length <= 1) {
            return line;
        }
        StringBuilder builder = new StringBuilder();
        for (int j = 0; j < splits.length - 1; ++j) {
            builder.append(splits[j]);
            builder.append("\n");
            for (int i = 0; i < 40; ++i) {
                builder.append(" ");
            }
        }
        builder.append(splits[splits.length - 1]);
        return builder.toString();
    }

    private static void printHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append("Options: ");
        builder.append("\n");
        int i = 0;
        for (ConfigOption option : ConfigOption.values()) {
            ++i;
            builder.append(option.option);
            builder.append(HadoopConfigClassifier.getPadding(option));
            builder.append(HadoopConfigClassifier.indent(option.help));
            builder.append("\n");
            if (i % 3 != 0) continue;
            builder.append("\n");
        }
        System.out.println(builder.toString());
    }

    private static void executeConfigOperation(ConfigOption mapr) throws IOException {
        assert (mapr.name().startsWith("MAPR"));
        assert (mapr.other.name().startsWith("APACHE"));
        Map<String, String> maprConfMap = HadoopConfigClassifier.getConfigurationAsMap(HadoopConfigClassifier.getConfigurationFor(mapr));
        Map<String, String> apacheConfMap = HadoopConfigClassifier.getConfigurationAsMap(HadoopConfigClassifier.getConfigurationFor(mapr.other));
        Configuration result = new Configuration(false);
        for (String key : maprConfMap.keySet()) {
            String apacheValue = apacheConfMap.get(key);
            String maprValue = maprConfMap.get(key);
            switch (mapr.operation) {
                case FIND_MAPR_MODIFIED_PROPERTIES: {
                    if (apacheValue != null && !apacheValue.equals(maprValue)) {
                        result.set(key, maprValue);
                        break;
                    }
                    if (apacheValue != null || maprValue == null) break;
                    result.set(key, maprValue);
                    break;
                }
                case FIND_MAPR_ADDED_PROPERTIES: {
                    if (apacheValue != null && !apacheValue.isEmpty()) break;
                    result.set(key, maprValue);
                }
            }
        }
        result.writeXml((OutputStream)System.out);
        System.out.println();
    }

    private static Map<String, String> getConfigurationAsMap(Configuration conf) {
        HashMap<String, String> confMap = new HashMap<String, String>();
        for (Map.Entry entry : conf) {
            confMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return confMap;
    }

    private static void printPropertiesForOption(ConfigOption option) throws IOException {
        Configuration configuration = HadoopConfigClassifier.getConfigurationFor(option);
        configuration.writeXml((OutputStream)System.out);
        System.out.println();
    }

    private static Configuration getConfigurationFor(ConfigOption option) {
        Configuration configuration = new Configuration(false);
        for (String source : option.sources) {
            configuration.addResource(source);
        }
        return configuration;
    }

    public static void main(String[] args) throws IOException {
        ConfigUtil.addDeprecatedKeys();
        if (args.length == 0) {
            HadoopConfigClassifier.printHelp();
        } else if (args.length > 0 && OPTIONS.containsKey(args[0])) {
            ConfigOption option = OPTIONS.get(args[0]);
            if (option != null && option.other != null && option.operation != null) {
                HadoopConfigClassifier.executeConfigOperation(option);
            } else if (option != null) {
                HadoopConfigClassifier.printPropertiesForOption(option);
            } else {
                HadoopConfigClassifier.printHelp();
            }
        } else {
            HadoopConfigClassifier.printHelp();
        }
    }

    static {
        for (ConfigOption option : ConfigOption.values()) {
            OPTIONS.put(option.option, option);
        }
    }

    static enum ConfigOption {
        APACHE_CORE_DEFAULT("print-apache-core-default-xml", "Prints properties defined in Apache Hadoop's core-default.xml.", new String[]{"core-default.xml"}, null, null),
        APACHE_MAPRED_DEFAULT("print-apache-mapred-default-xml", "Prints properties defined in Apache Hadoop's mapred-default.xml.", new String[]{"mapred-default.xml"}, null, null),
        APACHE_YARN_DEFAULT("print-apache-yarn-default-xml", "Prints properties defined in Apache Hadoop's yarn-default.xml.", new String[]{"yarn-default.xml"}, null, null),
        MAPR_MODIFIED_CORE_DEFAULT("print-mapr-modified-core-properties", "Prints MapR's modifications of properties defined in Apache Hadoop's core-default.xml.", new String[]{"org.apache.hadoop.conf.CoreDefaultProperties"}, APACHE_CORE_DEFAULT, Operation.FIND_MAPR_MODIFIED_PROPERTIES),
        MAPR_MODIFIED_MAPRED_DEFAULT("print-mapr-modified-mapred-properties", "Prints MapR's modifications of properties defined in Apache Hadoop's mapred-default.xml.", new String[]{"org.apache.hadoop.mapreduce.conf.MapReduceDefaultProperties"}, APACHE_MAPRED_DEFAULT, Operation.FIND_MAPR_MODIFIED_PROPERTIES),
        MAPR_MODIFIED_YARN_DEFAULT("print-mapr-modified-yarn-properties", "Prints MapR's modifications of properties defined in Apache Hadoop's yarn-default.xml.", new String[]{"org.apache.hadoop.yarn.conf.YarnDefaultProperties"}, APACHE_YARN_DEFAULT, Operation.FIND_MAPR_MODIFIED_PROPERTIES),
        MAPR_ADDED_CORE_DEFAULT("print-mapr-added-core-properties", "Prints MapR's additions to properties defined in Apache Hadoop's core-default.xml.", new String[]{"org.apache.hadoop.conf.CoreDefaultProperties"}, APACHE_CORE_DEFAULT, Operation.FIND_MAPR_ADDED_PROPERTIES),
        MAPR_ADDED_MAPRED_DEFAULT("print-mapr-added-mapred-properties", "Prints MapR's additions to properties defined in Apache Hadoop's mapred-default.xml.", new String[]{"org.apache.hadoop.mapreduce.conf.MapReduceDefaultProperties"}, APACHE_MAPRED_DEFAULT, Operation.FIND_MAPR_ADDED_PROPERTIES),
        MAPR_ADDED_YARN_DEFAULT("print-mapr-added-yarn-properties", "Prints MapR's additions to properties defined in Apache Hadoop's yarn-default.xml.", new String[]{"org.apache.hadoop.yarn.conf.YarnDefaultProperties"}, APACHE_YARN_DEFAULT, Operation.FIND_MAPR_ADDED_PROPERTIES),
        CORE_SITE("print-core-site-xml", "Prints properties as defined in core-site.xml on this box.", new String[]{"core-site.xml"}, null, null),
        MAPRED_SITE("print-mapred-site-xml", "Prints properties as defined in yarn-site.xml on this box.", new String[]{"mapred-site.xml"}, null, null),
        YARN_SITE("print-yarn-site-xml", "Prints properties as defined in yarn-site.xml on this box.", new String[]{"yarn-site.xml"}, null, null),
        EFFECTIVE_CORE("print-effective-core-properties", "Prints effective values of 'core' properties. The effective values are obtained by{}superimposing admin modified 'core' properties (in core-site.xml) and MapR added/modified{}'core' properties (in MapR binaries) on top of Apache Hadoop's core-default.xml.{} ", new String[]{"core-default.xml", "org.apache.hadoop.conf.CoreDefaultProperties"}, null, null),
        EFFECTIVE_MAPRED("print-effective-mapred-properties", "Prints effective values of 'mapred' properties. The effective values are obtained by{}superimposing admin modified 'mapred' properties (in mapred-site.xml)and MapR added/modified{}'mapred' properties (in MapR binaries) on top of Apache Hadoop's mapred-default.xml.{} ", new String[]{"mapred-default.xml", "org.apache.hadoop.mapreduce.conf.MapReduceDefaultProperties"}, null, null),
        EFFECTIVE_YARN("print-effective-yarn-properties", "Prints effective values of 'yarn' properties. The effective values are obtained by{}superimposing admin modified 'yarn' properties (in yarn-site.xml)and MapR added/modified{}'yarn' properties (in MapR binaries) on top of Apache Hadoop's yarn-default.xml.", new String[]{"yarn-default.xml", "org.apache.hadoop.yarn.conf.YarnDefaultProperties"}, null, null),
        ALL("print-all-effective-properties", "Prints effective values of 'core,mapred,yarn' properties. The effective values{}are obtained by superimposing admin modified {core,mapred,yarn} properties{}(in *-site.xml) and MapR added/modified {core,mapred,yarn} properties (in MapR binaries){}on top of Apache Hadoop's {core,mapred,yarn}-default.xml.", new String[]{"core-default.xml", "org.apache.hadoop.conf.CoreDefaultProperties", "core-site.xml", "mapred-default.xml", "org.apache.hadoop.mapreduce.conf.MapReduceDefaultProperties", "mapred-site.xml", "yarn-default.xml", "org.apache.hadoop.yarn.conf.YarnDefaultProperties", "yarn-site.xml"}, null, null);

        private String option;
        private String help;
        private String[] sources;
        private ConfigOption other;
        private Operation operation;

        private ConfigOption(String option, String help, String[] sources, ConfigOption other, Operation operation) {
            this.option = option;
            this.help = help;
            this.sources = sources;
            this.other = other;
            this.operation = operation;
        }
    }

    static enum Operation {
        FIND_MAPR_MODIFIED_PROPERTIES,
        FIND_MAPR_ADDED_PROPERTIES;

    }
}

